const WebSocket = require('ws');
const wss = new WebSocket.Server({ port: 8080 }); // Create a WebSocket server on port 8080

wss.on('connection', ws => {
    console.log('Client connected');

    // Listen for messages from the client
    ws.on('message', message => {
        console.log(`Received message: ${message}`);
        // Echo the message back to the client
        ws.send(`Server received: ${message}`);
    });

    // Handle the client closing the connection
    ws.on('close', () => {
        console.log('Client disconnected');
    });
    
    // Handle errors
    ws.on('error', error => {
        console.error('WebSocket error:', error);
    });
});

console.log('WebSocket server is running on ws://localhost:8080');
