// CVSD Midterm 2006 Fall
// S3TC-like compression
`timescale 1ns/10ps

module testS3TC;

parameter   CYCLE=50;
parameter   HALF_CYCLE=25;
parameter   block_size=16;

reg         clk;
reg         rst;
integer     i, j, err;

reg  [7:0]  datai;
reg         starti;
wire [1:0]  datao;
wire        valid;


// 4x4 block for texture
reg [7:0]   texel_data[15:0];
reg [1:0]   texel_type[15:0];

s3tc_comp s0( .texel_type(datao),
            .valid(valid),
            .start(starti),
            .texel_data(datai),  
            .clk(clk), 
            .rst(rst)  );

always #HALF_CYCLE
    clk =   ~clk;

initial
begin
    //$sdf_annotate("s3tc_comp_syn.sdf",testS3TC.s0);
    clk     =   1'b1;
    rst   =   1'b1;
    starti  = 1'b0;
    $fsdbDumpfile("s3tc.fsdb");
    $fsdbDumpvars;
    i       =   0;
    j       =   0;
    err     =   0;
    $readmemh("texel_data.txt", texel_data);
    $readmemh("texel_type.txt", texel_type);

    #(3*CYCLE);
    #1;
    rst     =   1'b0;
    #(3*CYCLE);
    #1;
    
    starti = 1'b1;
    #(CYCLE);
    starti = 1'b0;
    for (i=0; i<block_size; i=i+1 )
    begin
        datai   =   texel_data[i];
        #(CYCLE);
    end
    #50000;
    $finish;
end

always @(negedge clk)
begin
    if (valid)
    begin
        if ( datao != texel_type[j] )
        begin
            $display("[error] The type of the %x texel != %x, should be %x.", j, datao, texel_type[j]);
            err = err + 1;
        end
        j = j + 1;

        if ( j == 16 )
        begin
            if ( err == 0 )
                $display("Congratulations! Your code is correct!");
            else
                $display("OH~~You got %x errors!", err);
        end
    end
end

endmodule
