`timescale 1ns/100ps

module TestClock();

reg				clk, rst, start, mode;
reg		[4:0]	hour_s;
reg		[5:0]	min_s, sec_s;
reg		[4:0]	hour_t;
reg		[5:0]	min_t, sec_t;
integer			i, cycle, done, delay;
wire	[16:0]	time_o;
wire			alarm_o;

always #5 clk = ~clk;

dut Clock(.clk_p_i(clk), .rst_n_i(rst), .start_i(start), .mode_i(mode), 
		  .set_i({hour_s, min_s, sec_s}), .time_o(time_o), .alarm_o(alarm_o));

initial
begin
	$fsdbDumpfile("clock.fsdb");
	$fsdbDumpvars;
	clk = 1'b1;
	rst = 1'b1;
	start = 1'b0;
	cycle = 0;
	
	///////////
	//Reset DUT
	///////////
	@(negedge clk)
	rst = 1'b0;
	////////////////
	//Test Session 1
	////////////////
	@(negedge clk)
	rst = 1'b1;
	start = 1'b1;
	mode = 1'b0;
	hour_s = 5'd0; min_s = 6'd30; sec_s = 6'd59;
	hour_t = 5'd0; min_t = 6'd30; sec_t = 6'd59;
	$display ("Counting Up to %d:%d:%d\n", hour_s, min_s, sec_s);
	@(negedge clk)
	start = 1'b0;
	mode = 1'b0;
	hour_s = 5'd0; min_s = 6'd0; sec_s = 6'd0;
	done = 0;
	while (done===0)
	begin
		@(negedge clk)
		hour_s = (min_s===6'd59 & sec_s===6'd59)? hour_s+5'd1: hour_s;
		min_s = (min_s===6'd59 & sec_s===6'd59)? 6'd0: (sec_s===6'd59)? min_s+6'd1: min_s;
		sec_s = (sec_s===6'd59)? 6'd0: sec_s+6'd1;
		
		if ((time_o[16:12]!==hour_s) | (time_o[11:6]!==min_s) | (time_o[5:0]!==sec_s))
		begin
			$display ("Correct Time is %d:%d:%d, but Your Time is %d:%d:%d\n", hour_s, min_s, sec_s, time_o[16:12], time_o[11:6], time_o[5:0]);
			$finish;
		end
		
		if ((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t))
		begin
			if (alarm_o===1'b1)
			begin
				$display ("Your Time is Up (%d:%d:%d), and It Alarms Correctly\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				done = 1;
			end
			else
			begin
				$display ("Your Time is Up (%d:%d:%d), but It Doesn't Alarm\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
		else
		begin
			if (alarm_o===1'b1) 
			begin
				$display ("Your Time is Just %d:%d:%d, but It Alarms\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
	end
	delay = ($stime)%32;
	$display ("Hold Alarm fot Random Delay Test: %d Second(s)\n", delay);
	for (i=0; i<=delay; i=i+1)
	begin
		@(negedge clk)
		if ((alarm_o!==1'b1) | ~((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t)))
		begin
			$display ("Alarm Status is Not Correctly Held\n");
			$finish;
		end
	end
	
	///////////
	//Reset DUT
	///////////
	@(negedge clk)
	rst = 1'b0;
	////////////////
	//Test Session 2
	////////////////
	@(negedge clk)
	rst = 1'b1;
	start = 1'b1;
	mode = 1'b1;
	hour_s = 5'd0; min_s = 6'd30; sec_s = 6'd59;
	hour_t = 5'd0; min_t = 6'd0; sec_t = 6'd0;
	$display ("Counting Down from %d:%d:%d\n", hour_s, min_s, sec_s);
	@(negedge clk)
	start = 1'b0;
	mode = 1'b0;
	//hour_s = 5'd0; min_s = 6'd30; sec_s = 6'd59;
	done = 0;
	while (done===0)
	begin
		@(negedge clk)
		hour_s = (min_s===6'd0 & sec_s===6'd0)? hour_s-5'd1: hour_s;
		min_s = (min_s===6'd0 & sec_s===6'd0)? 6'd59: (sec_s===6'd0)? min_s-6'd1: min_s;
		sec_s = (sec_s===6'd0)? 6'd59: sec_s-6'd1;
		
		if ((time_o[16:12]!==hour_s) | (time_o[11:6]!==min_s) | (time_o[5:0]!==sec_s))
		begin
			$display ("Correct Time is %d:%d:%d, but Your Time is %d:%d:%d\n", hour_s, min_s, sec_s, time_o[16:12], time_o[11:6], time_o[5:0]);
			$finish;
		end
		
		if ((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t))
		begin
			if (alarm_o===1'b1)
			begin
				$display ("Your Time is Up (%d:%d:%d), and It Alarms Correctly\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				done = 1;
			end
			else
			begin
				$display ("Your Time is Up (%d:%d:%d), but It Doesn't Alarm\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
		else
		begin
			if (alarm_o===1'b1) 
			begin
				$display ("Your Time is Just %d:%d:%d, but It Alarms\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
	end
	delay = ($stime)%32;
	$display ("Hold Alarm fot Random Delay Test: %d Second(s)\n", delay);
	for (i=0; i<=delay; i=i+1)
	begin
		@(negedge clk)
		if ((alarm_o!==1'b1) | ~((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t)))
		begin
			$display ("Alarm Status is Not Correctly Held\n");
			$finish;
		end
	end
	
	///////////
	//Reset DUT
	///////////
	@(negedge clk)
	rst = 1'b0;
	////////////////
	//Test Session 3
	////////////////
	@(negedge clk)
	rst = 1'b1;
	start = 1'b1;
	mode = 1'b0;
	hour_s = 5'd2; min_s = 6'd30; sec_s = 6'd0;
	hour_t = 5'd2; min_t = 6'd30; sec_t = 6'd0;
	$display ("Counting Up to %d:%d:%d\n", hour_s, min_s, sec_s);
	@(negedge clk)
	start = 1'b0;
	mode = 1'b0;
	hour_s = 5'd0; min_s = 6'd0; sec_s = 6'd0;
	done = 0;
	while (done===0)
	begin
		@(negedge clk)
		hour_s = (min_s===6'd59 & sec_s===6'd59)? hour_s+5'd1: hour_s;
		min_s = (min_s===6'd59 & sec_s===6'd59)? 6'd0: (sec_s===6'd59)? min_s+6'd1: min_s;
		sec_s = (sec_s===6'd59)? 6'd0: sec_s+6'd1;
		
		if ((time_o[16:12]!==hour_s) | (time_o[11:6]!==min_s) | (time_o[5:0]!==sec_s))
		begin
			$display ("Correct Time is %d:%d:%d, but Your Time is %d:%d:%d\n", hour_s, min_s, sec_s, time_o[16:12], time_o[11:6], time_o[5:0]);
			$finish;
		end
		
		if ((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t))
		begin
			if (alarm_o===1'b1)
			begin
				$display ("Your Time is Up (%d:%d:%d), and It Alarms Correctly\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				done = 1;
			end
			else
			begin
				$display ("Your Time is Up (%d:%d:%d), but It Doesn't Alarm\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
		else
		begin
			if (alarm_o===1'b1) 
			begin
				$display ("Your Time is Just %d:%d:%d, but It Alarms\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
	end
	delay = ($stime)%32;
	$display ("Hold Alarm fot Random Delay Test: %d Second(s)\n", delay);
	for (i=0; i<=delay; i=i+1)
	begin
		@(negedge clk)
		if ((alarm_o!==1'b1) | ~((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t)))
		begin
			$display ("Alarm Status is Not Correctly Held\n");
			$finish;
		end
	end	
	
	///////////
	//Reset DUT
	///////////
	@(negedge clk)
	rst = 1'b0;
	////////////////
	//Test Session 4
	////////////////
	@(negedge clk)
	rst = 1'b1;
	start = 1'b1;
	mode = 1'b1;
	hour_s = 5'd2; min_s = 6'd0; sec_s = 6'd30;
	hour_t = 5'd0; min_t = 6'd0; sec_t = 6'd0;
	$display ("Counting Down from %d:%d:%d\n", hour_s, min_s, sec_s);
	@(negedge clk)
	start = 1'b0;
	mode = 1'b0;
	//hour_s = 5'd2; min_s = 6'd0; sec_s = 6'd30;
	done = 0;
	while (done===0)
	begin
		@(negedge clk)
		hour_s = (min_s===6'd0 & sec_s===6'd0)? hour_s-5'd1: hour_s;
		min_s = (min_s===6'd0 & sec_s===6'd0)? 6'd59: (sec_s===6'd0)? min_s-6'd1: min_s;
		sec_s = (sec_s===6'd0)? 6'd59: sec_s-6'd1;
		
		if ((time_o[16:12]!==hour_s) | (time_o[11:6]!==min_s) | (time_o[5:0]!==sec_s))
		begin
			$display ("Correct Time is %d:%d:%d, but Your Time is %d:%d:%d\n", hour_s, min_s, sec_s, time_o[16:12], time_o[11:6], time_o[5:0]);
			$finish;
		end
		
		if ((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t))
		begin
			if (alarm_o===1'b1)
			begin
				$display ("Your Time is Up (%d:%d:%d), and It Alarms Correctly\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				done = 1;
			end
			else
			begin
				$display ("Your Time is Up (%d:%d:%d), but It Doesn't Alarm\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
		else
		begin
			if (alarm_o===1'b1) 
			begin
				$display ("Your Time is Just %d:%d:%d, but It Alarms\n", time_o[16:12], time_o[11:6], time_o[5:0]);
				$finish;
			end
		end
	end
	delay = ($stime)%32;
	$display ("Hold Alarm fot Random Delay Test: %d Second(s)\n", delay);
	for (i=0; i<=delay; i=i+1)
	begin
		@(negedge clk)
		if ((alarm_o!==1'b1) | ~((time_o[16:12]===hour_t) & (time_o[11:6]===min_t) & (time_o[5:0]===sec_t)))
		begin
			$display ("Alarm Status is Not Correctly Held\n");
			$finish;
		end
	end
	
	//Complete All Tests
	$display ("CONGRATULATIONS! Your Desing Passes All Tests!\n");
	$finish;
end

always @(posedge clk)
begin
	cycle = cycle+1;
	if (cycle > 100000)
	begin
		$display ("Over-100000-cycle Time Out Error!\n");
		$finish;
	end
end

endmodule