/***********************************************/
/*                                             */
/*      Binary Tree Test bench                 */
/*      File: binary_tree_tb_syn.v             */
/*                                             */
/***********************************************/
`timescale 1ns/10ps
`define	CYCLE							  10
`define	H_CYCLE						  5	
`define REG_HOLD_TIME				1 
`define REG_SETUP_TIME			1
`define DATA_NUMBER         8

/* ============================================ */
module binary_tree_test;
/* ============================================ */

//data storage
	reg	[7:0]  input_data [0: `DATA_NUMBER*8-1];
	reg [3:0]  label_answer [0: `DATA_NUMBER-1];
	reg [7:0]  dif_answer [0: `DATA_NUMBER-1];
	
//hk-means signal
	reg				  clk_p_i;
	reg				  reset_n_i;		
	reg [7:0]   data_i;	
	reg         valid_i;	
	
	wire [3:0]  label_o;
	wire [7:0]  min_dif_o;
	wire        valid_o;	
		
	reg [7:0]  temp;
	reg [7:0] i, j;
	reg [3:0] valid_error, label_error, min_dif_error;

//= binary tree to be tested =//
binary_tree BINARY_TREE(
.clk_p_i(clk_p_i),
.reset_n_i(reset_n_i),
.data_i(data_i),
.valid_i(valid_i),
.label_o(label_o),
.min_dif_o(min_dif_o),
.valid_o(valid_o)
);
initial $sdf_annotate("binary_tree.sdf", BINARY_TREE);
/* ============================================ */
//= Signal reset =//
	initial begin
		clk_p_i = 0;
		reset_n_i = 1;			
		data_i = 0;		
		valid_i = 0;	
		label_error = 0;	
		min_dif_error = 0;	
		valid_error = 0;
	end
/* ============================================ */
//= File I/O =//
	initial
	begin
		$fsdbDumpfile("binary_tree_syn.fsdb");			//Verdi fsdb file
		$fsdbDumpvars;													//Verdi fsdb file
		$readmemh("input.txt", input_data);		    			//Load input data from file
		$readmemh("label_answer.txt", label_answer);		    //Load output data from file		
		$readmemh("dif_answer.txt", dif_answer);		    //Load output data from file		
	end
/* ============================================ */
//= Clock signal =//
	always #(`H_CYCLE)
	begin
		clk_p_i = ~clk_p_i;
	end
/* ============================================ */
//= Control and input data =//
	initial begin
		
	# (`CYCLE);
	reset_n_i = 0;
	# (`CYCLE);
	reset_n_i = 1;			
	# (`CYCLE);
	
	$display("Binary Tree Testing Start");
	
	//loop until 
	for (i=0; i<`DATA_NUMBER; i=i+1) begin

		for (j=0; j<8; j=j+1) begin
			temp = input_data[i*8+j];
			data_i = temp;							
			valid_i = 1;		
			# (`CYCLE);
		end
	valid_i = 0;
	# (`CYCLE*3);
	if (valid_o !== 1)begin
	$display("No. %d Sequence Valid Signal Error", i);
	valid_error = valid_error + 1; 
	end
	if (label_answer[i] !== label_o)begin
	$display("No. %d Sequence Number Error: %h !== %h", i, label_answer[i], label_o);
	label_error = label_error + 1; 
	end
	if (dif_answer[i] !== min_dif_o)begin
	$display("No. %d Minimum Difference Error: %h !== %h", i, dif_answer[i], min_dif_o);
	min_dif_error = min_dif_error + 1; 
	end

	# (`CYCLE*5);

	end  
	$display("Testing Over!!");
	
	if (min_dif_error == 0 && label_error == 0 && valid_error == 0) $display("The results are correct. Congratulations !!! (*^o^*)");
	else begin
	$display("I regret to inform you that ...");
	$display("You have %d Valid Signal Errors", valid_error);
	$display("You have %d Sequence Number Errors", label_error);
	$display("You have %d Minimum Difference Errors", min_dif_error);
	end
		
	$finish;	
		
	end
/* ============================================ */
endmodule