﻿/*
 * 示範巢狀try...catch敘述之使用
 * 5/22/2010
 */

using System;

namespace NestedTryAndCatch
{
    class Program
    {
        static void Main(string[] args)
        {
            int nStudents = 1;
            bool validNStudents = false;
            do
            {
                Console.Write("輸入學生人數: ");
                try
                {
                    nStudents = int.Parse(Console.ReadLine());
                    if (nStudents > 0) validNStudents = true;
                }
                catch (FormatException e)
                {
                    Console.WriteLine(e.Message);
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                }
            } while (!validNStudents);
            try
            {
                Student[] table = new Student[nStudents];
                for (int i = 0; i < nStudents; ++i)
                {
                    bool validGrades = false;
                    do
                    {
                        Console.WriteLine("輸入第" + (i + 1) +
                            " 個學生學號及成績, 以一個空白分隔: ");
                        string line;
                        string[] data = new string[2];
                        try
                        {
                            line = Console.ReadLine();
                            data = line.Split(' ');
                            string regNo = data[0];
                            int grade = Convert.ToInt32(data[1]);
                            table[i] = new Student(regNo, grade);
                            Console.WriteLine(
                                "table[" + i + "] = {0} : {1}",
                                table[i].RegNo, table[i].Grade);
                            validGrades = true;
                        }
                        catch (GradeOutOfRangeException e)
                        {
                            Console.WriteLine(e);
                        }
                        catch (FormatException e)
                        {
                            Console.WriteLine(e.Message);
                        }
                    } while (!validGrades);
                }
            }
            catch (IndexOutOfRangeException e)
            {
                Console.WriteLine(e.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
    }

    class Student
    {
        private string regNo;
        private int grade;
        public Student(string regNo, int grade)
        {
            if (grade < 0 || grade > 100)
                throw new GradeOutOfRangeException(
                    regNo, grade);
            this.regNo = regNo;
            this.grade = grade;
        }
        public string RegNo
        {
            get { return regNo; }
        }
        public int Grade
        {
            get { return grade; }
        }
    }

    class GradeOutOfRangeException : ApplicationException
    {
        private string message;
        public GradeOutOfRangeException(string regNo, int grade)
            : base()
        {
            message = "學生" + regNo + "之分數" + grade +
                  "不在0與100之間";
        }
        public override string ToString()
        {
            return message;
        }
    }

}
