﻿/*
 * 測試類別Table
 * 10/2/2008
 */

using System;
using System.Diagnostics;

namespace TableDemo
{
    class TableTest
    {
        // Case 1: Test1.dat
        // +---------+---------+---------+
        // |    3    |    4    |    2    |
        // +---------+---------+---------+
        // |    5    |    7    |    6    |
        // +---------+---------+---------+
        //
        // 每列總和
        // +---------+---------+
        // |    9    |   18    |
        // +---------+---------+
        // 
        // 每欄總和
        // +---------+---------+---------+
        // |    8    |    11   |    8    |
        // +---------+---------+---------+
        //
        // 全部總和
        //   27
        public static bool Case1_OK()
        {
            Table table = new Table("Test1.dat");
            int[] rowSum = table.RowSum();
            Debug.Assert(rowSum[0] == 9);
            Debug.Assert(rowSum[1] == 18);
            int[] colSum = table.ColSum();
            Debug.Assert(colSum[0] == 8);
            Debug.Assert(colSum[1] == 11);
            Debug.Assert(colSum[2] == 8);
            Debug.Assert(table.TotalSum() == 27);
            return true;
        }
    }
}
