﻿/*
 * 示範使用者自訂例外之使用
 * 5/22/2010
 */

using System;

namespace UserDefinedException
{
    class Program
    {
        static void Main(string[] args)
        {
            int nStudents = 3;
		    Student[] table = new Student[nStudents];
            try
            {
                table[0] = new Student("B645330", 90);
                Console.WriteLine("table[0] = {0} : {1}", 
			    table[0].RegNo, table[0].Grade);
                table[1] = new Student("B645331", 102);
                //table[1] = new Student("B645331", 100);
                Console.WriteLine("table[1] = {0} : {1}", 
			        table[1].RegNo, table[1].Grade);
                table[2] = new Student("B645332", 55);
                Console.WriteLine("table[2] = {0} : {1}", 
			        table[2].RegNo, table[2].Grade);
                //Console.WriteLine("table[3] = {0} : {1}", 
		        //  table[3].RegNo, table[3].Grade);
            }
		    catch (GradeOutOfRangeException e)
            {
                Console.WriteLine(e);
            }
            catch (IndexOutOfRangeException e)
            {
                Console.WriteLine(e.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
    }

    class Student
    {
        private string regNo;
        private int grade;
        public Student(string regNo, int grade)
        {
            if (grade < 0 || grade > 100)
                throw new GradeOutOfRangeException(
                    regNo, grade);
            this.regNo = regNo;
            this.grade = grade;
        }
        public string RegNo
        {
            get { return regNo; }
        }
        public int Grade
        {
            get { return grade; }
        }
    }
    class GradeOutOfRangeException : ApplicationException
    {
        private string message;
        public GradeOutOfRangeException(
            string regNo, int grade) : base()
        {
            message = "學生" + regNo + "之分數" + grade +
                  "不在0與100之間";
        }
        public override string ToString()
        {
            return message;
        }
    }
}
