﻿/*
 * 以類別Student及GraduateStudent說明物件的序列化與去序列化
 * 5/22/2010
 */

using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.Diagnostics;


namespace UsingSerialization
{
    [Serializable]
    class Student
    {
        private string regNo;
        private string name;
        public Student()
        {
            regNo = "";
            name = "";
        }
        public Student(string regNo, string name)
        {
            this.regNo = regNo;
            this.name = name;
        }
        public string RegNO
        {
            get { return regNo; }
        }
        public string Name
        {
            get { return name; }
        }
    }
    [Serializable]
    class GraduateStudent : Student
    {
        private string advisor;
        public GraduateStudent() : base()
        {
            advisor = "";
        }
        public GraduateStudent(string regNo, string name, string advisor)
            : base(regNo, name)
        {
            this.advisor = advisor;
        }
        public string Advisor
        {
            get { return advisor; }
        }
    }
    class Program
    {
        static void Main(string[] args)
        {
            Student so1 = new Student("B645331", "Thomas");
            GraduateStudent so2 = new GraduateStudent("F685329", "Richard", "Aaron");
            BinaryFormatter formatter = new BinaryFormatter();
            try
            {
                FileStream output = new FileStream("Test.dat", FileMode.Create, FileAccess.Write);
                formatter.Serialize(output, so1);
                formatter.Serialize(output, so2);
                output.Close();
            }
            catch (SerializationException)
            {
                Console.WriteLine("Error writting to file in output");
            }
            catch (IOException)
            {
                Console.WriteLine("Can not create or close file for output");
            }
            try
            {
                FileStream input = new FileStream("Test.dat", FileMode.Open, FileAccess.Read);
                try
                {
                    while (true)
                    {
                        Object obj = formatter.Deserialize(input);
                        if (obj.GetType() == so1.GetType())
                        {
                            Student si = (Student)obj;
                            Console.WriteLine( si.RegNO + "\t" + si.Name );
                        }
                        else if (obj.GetType() == so2.GetType())
                        {
                            GraduateStudent si = (GraduateStudent)obj;
                            Console.WriteLine(si.RegNO + "\t" +  si.Name + "\t" + si.Advisor);
                        }
                        else
                        {
                            throw new SerializationException();
                        }
                    }
                }
                catch (SerializationException)
                {
                    // close stream if no data left
                    input.Close();
                }
                catch (IOException)
                {
                    Console.WriteLine("Can not close file for input");
                }
            }
            catch (FileNotFoundException)
            {
                Console.WriteLine("Can not open file in building intput");
            }
        }
    }
}
