﻿/* 
 * 捕捉不同例外
 * 5/14/2007
 */

using System;

namespace UsingTryCatch2
{
    class Program
    {
        static void Main(string[] args)
        {
            bool success = false;
            do
            {
                try
                {
	                Console.Write("輸入除數: ");
                    int number = int.Parse(Console.ReadLine());
                    int result = 5 / number;
                    Console.WriteLine("除結果為" + result);
                    success = true;
                }
                catch (FormatException e)
                {
                    Console.WriteLine("請輸入數值");
                    Console.WriteLine(e.Message);
                }
                catch (DivideByZeroException e)
                {
                    Console.WriteLine("不可除以零");
                    Console.WriteLine(e.Message);
                }
                catch (Exception e)
                {
                    Console.WriteLine("其他錯誤");
                    Console.WriteLine(e.Message);
                }
                finally
                {
                    if (!success) Console.WriteLine("再試一次");
                }
            } while (!success);
        }
    }
}
