﻿/*
 * 示範抽象類別之應用
 * skj  5/8/2010
 */
using System;

namespace AbstractClassExample
{
    class Program
    {
        static void Main(string[] args)
        {
            double a = 5.0;
            Square sq = new Square(a);
            Console.WriteLine("正方形sq之面積為" + sq.Area());
            Circle c = new Circle(a);
            Console.WriteLine("圓形c之面積為" + c.Area());
        }
    }
    abstract class Shape
    {
        private string shape;
        public Shape(string shape)
        {
            this.shape = shape;
            Console.WriteLine("建立" + shape);
        }
        abstract public double Area();
    }
    class Square : Shape
    {
        double a;
        public Square(double a)
            : base("正方形")
        {
            this.a = a;
        }
        public override double Area()
        {
            return a * a;
        }
    }
    class Circle : Shape
    {
        double r;
        public Circle(double r)
            : base("圓形")
        {
            this.r = r;
        }
        public override double Area()
        {
            return Math.PI * r * r;
        }
    }
}
