﻿/*
 * 21點測試
 * 5/8/2010
 */

using System;

namespace BlackJack_0_1
{
    class BlackJackTest
    {
        public static bool DeckRandom_OK()
        {
            Deck deck = new Deck(123);
            Card[] cards = new Card[52];
            int i;
            for (i = 0; i < 52; ++i)
            {
                cards[i] = deck.DealACard();
            }
            int[] nSuit = new int[4];
            int s;
            for (s = 0; s < 4; ++s)
            {
                nSuit[s] = 0;
            }
            int[] nRank = new int[13];
            int r;
            for (r = 0; r < 13; ++r)
            {
                nRank[r] = 0;
            }
            for (i = 0; i < 52; ++i)
            {
                switch (cards[i].suit)
                {
                    case Suit.CLUB:
                        nSuit[0]++;
                        break;
                    case Suit.DIAMOND:
                        nSuit[1]++;
                        break;
                    case Suit.HEART:
                        nSuit[2]++;
                        break;
                    case Suit.SPADE:
                        nSuit[3]++;
                        break;
                    default:
                        break;
                }
                nRank[cards[i].rank - 1]++;
            }
            bool suit_OK = true;
            for (s = 0; s < 4; s++)
            {
                if (nSuit[s] != 13)
                {
                    suit_OK = false;
                    break;
                }
            }
            bool rank_OK = true;
            for (r = 0; r < 13; r++)
            {
                if (nRank[r] != 4)
                {
                    rank_OK = false;
                    break;
                }
            }
            return suit_OK && rank_OK;
        }
        public static bool Scenario_1_OK()
        {
            Card[] cards = { new Card(Suit.SPADE, 1),
                           new Card(Suit.HEART, 11),
                           new Card(Suit.DIAMOND, 10)
                           };
            Deck deck = new Deck(cards);
			Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            return(player.GetStatus() == Status.BLACK_JACK &&
                   dealer.GetStatus() == Status.PASS);
        }
        public static bool Scenario_2_OK()
        {
            Card[] cards = { new Card(Suit.CLUB, 3),
                            new Card(Suit.HEART, 11),
                            new Card(Suit.SPADE, 10),
                            new Card(Suit.DIAMOND, 1)
                           };
            Deck deck = new Deck(cards);
            Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            return (player.GetStatus() == Status.PASS &&
                    dealer.GetStatus() == Status.BLACK_JACK);

        }
        public static bool Scenario_3_OK()
        {
            Card[] cards = { new Card(Suit.SPADE, 8),
                            new Card(Suit.HEART, 11),
                           new Card(Suit.DIAMOND, 7),
                             new Card(Suit.SPADE, 2),
                             new Card(Suit.CLUB, 6)
                           };
            Deck deck = new Deck(cards);
            Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            return (player.GetStatus() == Status.BLACK_JACK &&
                    dealer.GetStatus() == Status.PASS);

        }
        public static bool Scenario_4_OK()
        {
            Card[] cards = { new Card(Suit.SPADE, 8),
                             new Card(Suit.HEART, 5),
                           new Card(Suit.DIAMOND, 8),
                             new Card(Suit.SPADE, 9),
                             new Card(Suit.CLUB, 6)
                           };
            Deck deck = new Deck(cards);
            Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            return (player.GetStatus() == Status.BURST &&
                    dealer.GetStatus() == Status.PASS);

        }
        public static bool Scenario_5_OK()
        {
            Card[] cards = { new Card(Suit.SPADE, 8),
                             new Card(Suit.HEART, 5),
                           new Card(Suit.DIAMOND, 8),
                             new Card(Suit.SPADE, 9),
                             new Card(Suit.CLUB, 6)
                           };
            Deck deck = new Deck(cards);
            Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            return (player.GetTotalPoints() == 16 &&
                    dealer.GetTotalPoints() == 20);
        }
        public static bool Scenario_6_OK()
        {
            Card[] cards = { new Card(Suit.SPADE, 8),
                             new Card(Suit.HEART, 5),
                           new Card(Suit.DIAMOND, 8),
                             new Card(Suit.SPADE, 9),
                             new Card(Suit.CLUB, 8)
                           };
            Deck deck = new Deck(cards);
            Player player = new Player();
            Dealer dealer = new Dealer();
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            player.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            dealer.SaveACard(deck.DealACard());
            return (player.GetTotalPoints() == 16 &&
                    dealer.GetTotalPoints() == 22 &&
                    dealer.GetStatus() == Status.BURST);
        }
        public static bool Game_OK()
        {
            Console.WriteLine("Game 測試");
            Game game = new Game();
            game.Run(123);
            return true;
        }
    }
}
