﻿/*
 * 模擬牌疊
 * 3/6/2009
 */

using System;

namespace BlackJack_0_1
{
    class Deck
    {
        private Card[] cards = new Card[52];
        private int top = 0;
        public Deck()
        {
            Random rand = new Random();
            PrepareDeck(rand);
        }
        public Deck(int seed)
        {
            Random rand = new Random(seed);
            PrepareDeck(rand);
        }
        // Reference: ArrayAndFileIO.ppt, p. 35
        private void PrepareDeck(Random rand)
        {
            int i;
            bool[] used = new bool[52];
            for (i = 0; i < 52; ++i)
            {
                used[i] = false;
            }
            int pos; // position in the table given 
            // in reference
            int s;
            for (i = 0; i < 52; ++i)
            {
                pos = rand.Next() % 52;

                // search for un-used position
                while (used[pos])
                {
                    ++pos;
                    pos = pos % 52;
                }
                s = pos / 13;
                switch (s)
                {
                    case 0:
                        cards[i].suit = Suit.CLUB;
                        break;
                    case 1:
                        cards[i].suit = Suit.DIAMOND;
                        break;
                    case 2:
                        cards[i].suit = Suit.HEART;
                        break;
                    case 3:
                        cards[i].suit = Suit.SPADE;
                        break;
                    default:
                        break;
                }
                cards[i].rank = pos % 13 + 1;
                used[pos] = true;
            }
        }
        public Deck(Card[] cards)
        {
            int nCards = cards.Length;
            this.cards = new Card[nCards];
            int i;
            for (i = 0; i < nCards; ++i)
            {
                this.cards[i] = cards[i];
            }
        }
        public Card DealACard()
        {
            return cards[top++];
        }
        public bool HasMoreCard()
        {
            return (top < 52);
        }
    }
}
