﻿/*
 * 二十一點遊戲
 * 主控台遊戲版本
 * 3/15/2009
 */

using System;

namespace BlackJack_0_1
{
    class Game
    {
        const int N_PLAYERS = 2;
        Deck deck;
        Player[] players = new Player[N_PLAYERS];
        public Game()
        {
            players[0] = new Player("Jeng");
            players[N_PLAYERS - 1] = new Dealer();
        }
        public void Run()
        {
            deck = new Deck();
            Play();
        }
        public void Run(int seed)
        {
            deck = new Deck(seed);
            Play();
        }
        private void Play()
        {
            int i;
            // 第一輪發牌
            for (i = 0; i < N_PLAYERS; ++i)
            {
                players[i].SaveACard(
                deck.DealACard());
                players[i].Dump();
            }
            // 第二輪發牌
            for (i = 0; i < N_PLAYERS; ++i)
            {
                players[i].SaveACard(
                deck.DealACard());
                players[i].Dump();
            }
            // 開始要牌計牌
            for (i = 0; i < N_PLAYERS; ++i)
            {
                while (players[i].GetStatus() ==
                    Status.PASS &&
                       players[i].WantOneMoreCard()
                    && deck.HasMoreCard())
                {
                    players[i].SaveACard(
                      deck.DealACard());
                    players[i].Dump();
                    if (IsBlackJackOrBurst(
                        players[i])) return;
                }
            }
            // 計點分勝負
            Player dealer = players[N_PLAYERS - 1];
            for (i = 0; i < N_PLAYERS - 1; ++i)
            {
                if (dealer.GetTotalPoints() >=
                  players[i].GetTotalPoints())
                {
                    Console.WriteLine(dealer.Name +
                    "勝" + players[i].Name);
                }
                else
                {
                    Console.WriteLine(
                    players[i].Name + "勝" + dealer.Name);
                }
            }
        }
  	    private bool IsBlackJackOrBurst(Player player) {
            bool isBlackJack = false;
            if (player.GetStatus() == Status.BLACK_JACK) 
            {
                isBlackJack = true;
                Console.WriteLine(
				player.Name+" BlackJack!!!");
            }
            bool isBurst = false;
            if (player.GetStatus() == Status.BURST)
            {
                isBurst = true;
                Console.WriteLine(
				player.Name+" 爆!!!");
            }
            return (isBlackJack || isBurst); 
        }
    }
}
