﻿/*
 * 模擬玩家
 * 3/15/2009
 */

using System;

namespace BlackJack_0_1
{
    class Player
    {
        // a player can have at most 11 cards
        // {A, A, A, A, 2, 2, 2, 2, 3, 3, 3}
        // for not burst or BlackJack
        private Card[] hand = new Card[11];
        private int nCards;
        private Status status;
        private int totalPoints;
        private string name;
        public Player()
        {
            nCards = 0;
            name = "無名氏";
        }
        public Player(string name)
        {
            nCards = 0;
            this.name = name;
        }
        public string Name
        {
            get { return name; }
        }
        public void SaveACard(Card card)
        {
            hand[nCards++] = card;
            StatusChecker.DetermineStatusAndTotalPoints( hand, nCards, out status, out totalPoints );
        }
        public Status GetStatus()
        {
            return status;
        }
        public int GetTotalPoints()
        {
            return totalPoints;
        }
        virtual public bool WantOneMoreCard()
        {
            Console.Write("要再一張牌嗎? (y/n) ");
            string answer = Console.ReadLine();
            return (answer == "Y" || answer == "y");
        }
        public void Dump()
        {
            int i;
            Console.Write(name+" 牌: ");
            for (i = 0; i < nCards; ++i)
            {
                hand[i].Dump();
                Console.Write("\t");
                if ((i + 1) % 5 == 0)
                    Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine(name + " 總點數: " +
                totalPoints);
        }
    }
}
