﻿/*
 * 示範多重介面同名函式的使用
 * 5/8/2010
 */

using System;

namespace CastMultiInterfaces
{
    class Program
    {
        static void Main(string[] args)
        {
            double a = 5.0;
            Square sq = new Square(a);
            Rhombus rhomb = sq as Rhombus;
            Console.WriteLine(
                "sq的面積以菱形公式計算得" + rhomb.Area());
	        if( sq is Rectangle ) 
            {
                Rectangle rec = (Rectangle) sq;
                Console.WriteLine(
		            "sq的面積以矩形公式計算得"+rec.Area() );
            }
        }
    }

    interface Rectangle
    {
        double Area();
    }
    interface Rhombus
    {
        double Area();
    }

	class Square : Rectangle, Rhombus
    {
        private double a;
        private double d;
        public Square(double a) 
        {
            this.a = a;
            d = Math.Sqrt(2.0) * a;
        }
        double Rectangle.Area()
        {
            return a * a;
        }
        double Rhombus.Area()
        {
            return 0.5 * d * d;
        }
    }
}
