﻿/*
 * 一個違反DIP的例子
 * 參考: Robert C. Martin, Agile Software Development: Principles, Patterns, 
 * and Practices, Pearson Education, 2003, p. 130.
 * 5/8/2010
 */

using System;

namespace DIPViolationExample
{
    enum LampStatus
    {
        OFF = 0,
        ON = 1
    }

    enum ButtonStatus
    {
        RELEASED = 0,
        PRESSED = 1
    }

    class Lamp
    {
        private LampStatus status = LampStatus.OFF;
        public LampStatus Status
        {
            get { return status; }
        }
        public void TurnOn()
        {
            status = LampStatus.ON;
        }
        public void TurnOff()
        {
            status = LampStatus.OFF;
        }      
    }

    class Button
    {
        private ButtonStatus status = ButtonStatus.RELEASED;
        private Lamp lamp;
        public Button(Lamp lamp)
        {
            this.lamp = lamp;
        }
        public ButtonStatus Status
        {
            get { return status; }
        }
        public void Press()
        {
            if (status == ButtonStatus.RELEASED)
            {
                status = ButtonStatus.PRESSED;
                lamp.TurnOn();
            }
        }
        public void Release()
        {
            if( status == ButtonStatus.PRESSED )
            {
                status = ButtonStatus.RELEASED;
                lamp.TurnOff();
            }
        }

    }
    class Program
    {
        static void Main(string[] args)
        {
            Lamp lamp1 = new Lamp();
            Button button = new Button(lamp1);
            Random rand = new Random();
            for (int n = 0; n <= 100; ++n)
            {
                Console.Write("time n = " + n + "\t");
                if (rand.Next() % 2 == 1)
                {
                    if (button.Status == ButtonStatus.PRESSED)
                    {
                        button.Release();
                    }
                    else
                    {
                        button.Press();
                    }
                }
                if (lamp1.Status == LampStatus.OFF)
                {
                    Console.WriteLine("lamp1 is off");
                }
                else
                {
                    Console.WriteLine("lamp1 is on");
                }
                Console.WriteLine();
            }
        }
    }
}
