﻿/* 
 * 說明成員變數的繼承關係
 * skj  5/17/2010
 */


using System;
using System.Diagnostics;

namespace DataMemberInheritance
{
    class A
    {
        private int data1;
        private int data2;
        public A()
        {
            data1 = 1;
            data2 = 2;
        }
        public void GetAData(out int data1, out int data2)
        {
            data1 = this.data1;
            data2 = this.data2;
        }
    }

    class B : A
    {
        private int data3;
        public B()
        {
            data3 = 3;
        }
        public void GetBData(out int data3)
        {
            data3 = this.data3;
        }
    }

    class C : B
    {
        private int data1;
        private int data4;
        public C()
        {
            data1 = 5;
            data4 = 4;
        }
        public void GetCData(out int data1, out int data4)
        {
            data1 = this.data1;
            data4 = this.data4;
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            A a = new A();
            B b = new B();
            C c = new C();
            int data1;
            int data2;
            int data3;
            int data4;
            a.GetAData(out data1, out data2);
            Debug.Assert(data1 == 1 && data2 == 2);
            b.GetAData(out data1, out data2);
            Debug.Assert(data1 == 1 && data2 == 2);
            b.GetBData(out data3);
            Debug.Assert(data3 == 3);
            c.GetAData(out data1, out data2);
            Debug.Assert(data1 == 1 && data2 == 2);
            c.GetBData(out data3);
            Debug.Assert(data3 == 3);
            c.GetCData(out data1, out data4);
            Debug.Assert(data1 == 5 && data4 == 4);
        }
    }
}
