﻿/*
 * 以圖形繪製說明多型的應用
 * 10/9/2008
 */

using System;

namespace DrawingAllShapes
{
    class Program
    {
        static void Main(string[] args)
        {
            Shape[] list = new Shape[3];
            Point center;
            center.x = 15;
            center.y = 20;
            Point topLeft;
            topLeft.x = 30;
            topLeft.y = 40;
            Circle c = new Circle(2, center);
            Rectangle r = new Rectangle(3, 4, topLeft);
            Point vertex1;
            vertex1.x = 10;
            vertex1.y = 12;
            Point vertex2;
            vertex2.x = 5;
            vertex2.y = 5;
            Point vertex3;
            vertex3.x = 18;
            vertex3.y = 20;
            Triangle t = new Triangle(vertex1, vertex2, vertex3);
            Console.WriteLine("決定畫圖順序, 輸入");
            Console.WriteLine("1: 圓形, 矩形, 三角形");
            Console.WriteLine("2: 三角形, 矩形, 圓形");
            int ans = int.Parse(Console.ReadLine());
            switch (ans)
            {
                case 1:
                    list[0] = c;
                    list[1] = r;
                    list[2] = t;
                    break;
                case 2:
                    list[0] = t;
                    list[1] = r;
                    list[2] = c;
                    break;
                default:
                    list[0] = t;
                    list[1] = r;
                    list[2] = c;
                    break;
            }
            DrawAllShapes(list);
        }
        static void DrawAllShapes(Shape[] list)
        {
            int i;
            for (i = 0; i < list.Length; ++i)
            {
                list[i].Draw();
            }
        }
    }
    struct Point
    {
        public int x;
        public int y;
    }
    class Shape
    {
        public Shape() { }
        virtual public void Draw() { }
    }
    class Circle : Shape
    {
        private int radius;
        private Point center;
        public Circle(int radius, Point center)
        {
            this.radius = radius;
            this.center = center;
        }
        override public void Draw()
        {
            Console.WriteLine("Draw a circle");
        }
    }
    class Rectangle : Shape
    {
        private int width;
        private int height;
        private Point topLeft;
        public Rectangle(int width, int height, Point topLeft)
        {
            this.width = width;
            this.height = height;
            this.topLeft = topLeft;
        }
        override public void Draw()
        {
            Console.WriteLine("Draw a rectangle");
        }
    }
    class Triangle : Shape
    {
        private Point vertex1;
        private Point vertex2;
        private Point vertex3;
        public Triangle(Point vertex1, Point vertex2, Point vertex3)
        {
            this.vertex1 = vertex1;
            this.vertex2 = vertex2;
            this.vertex3 = vertex3;
        }
        public override void Draw()
        {
            Console.WriteLine("Draw a triangle");
        }
    }
}
