﻿/*
 * 一個違反LSP的例子
 * 參考: Robert C. Martin, Agile Software Development: Principles, Patterns, 
 * and Practices, Pearson Education, 2003, p. 115.
 * 10/10/2008
 */
using System;
using System.Diagnostics;

namespace LSPViolationExample
{
    class Rectangle
    {
        private int width;
        private int height;
        virtual public int Width
        {
            set { width = value; }
            get { return width; }
        }
        virtual public int Height
        {
            set { height = value; }
            get { return height; }
        }
        public int Area()
        {
            return width * height;
        }
    }
    class Square : Rectangle
    {
        override public int Width
        {
            set { base.Width = value; base.Height = value; }
            get { return Width; }
        }
        override public int Height
        {
            set { base.Width = value; base.Height = value; }
            get { return Height; }
        }
    }
    class Program
    {
        static void Main(string[] args)
        {
            Square s = new Square();
            Test(s);
        }
        static void Test(Rectangle r)
        {
            r.Width = 5;
            r.Height = 4;
            Debug.Assert(r.Area() == 20);
        }
    }
}
