﻿/* 
 * 進一步說明成員函式的繼承關係
 * skj  5/17/2010
 */

using System;
using System.Diagnostics;

namespace MemberFunctionInheritance
{
    class A
    {
        private int data1;
        private int data2;
        public A()
        {
            data1 = 1;
            data2 = 2;
        }
        public int GetData1()
        {
            return data1;
        }
        public int GetData2()
        {
            return data2;
        }
    }

    class B : A
    {
        private int data3;
        public B()
        {
            data3 = 3;
        }
        public int Data3
        {
            get { return data3; }
        }
        public int GetSum()
        {
            return (GetData2() + data3);
        }
    }

    class C : B
    {
        private int data1;
        private int data4;
        public C()
        {
            data1 = 5;
            data4 = 4;
        }
        public new int GetData1()
        {
            return data1;
        }
        public int GetData4()
        {
            return data4;
        }
        public int GetAData1()
        {
            return base.GetData1();
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            A a = new A();
            B b = new B();
            C c = new C();
            int data1;
            int data2;
            int data3;
            int data4;
            data1 = a.GetData1();
            data2 = a.GetData2();
            Debug.Assert(data1 == 1 && data2 == 2);
            data1 = b.GetData1();
            data2 = b.GetData2();
            data3 = b.Data3;
            Debug.Assert(data1 == 1 && data2 == 2 && data3 == 3);
            int sum = b.GetSum();
            Debug.Assert(sum == 5);
            data1 = c.GetData1();
            data2 = c.GetData2();
            data3 = c.Data3;
            data4 = c.GetData4();
            int aAData1 = c.GetAData1();
            Debug.Assert(data1 == 5 && data2 == 2 && 
                         data3 == 3 && data4 == 4 &&
                         aAData1 == 1);
        }
    }
}
