﻿/* 示範new與override關鍵字的用法
 * Ref: C# 程式設計人員參考 
 * 瞭解使用new和override關鍵字的時機(C# 程式設計手冊)  
 * mshelp://MS.VSExpressCC.v80/MS.NETFramework.v20.cht/
 * dv_csref/html/323db184-b136-46fc-8839-007886e7e8b0.htm
 * 5/8/2010
 */

using System;

namespace NewVSOverride
{
    // Define the base class
    class Car
    {
        public virtual void DescribeCar()
        {
            Console.WriteLine(
                "Four wheels and an engine.");
        }
    }

    // Define the derived classes
    class ConvertibleCar : Car
    {
        public new virtual void DescribeCar()
        {
            base.DescribeCar();
            Console.WriteLine(
                "A roof that opens up.");
        }
    }

    class Minivan : Car
    {
        public override void DescribeCar()
        {
            base.DescribeCar();
            Console.WriteLine(
                "Carries seven people.");
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            // new and override make no differences here
            Car car1 = new Car();
            car1.DescribeCar();
            Console.WriteLine("----------");

            ConvertibleCar car2 = new ConvertibleCar();
            car2.DescribeCar();
            Console.WriteLine("----------");

            Minivan car3 = new Minivan();
            car3.DescribeCar();
            Console.WriteLine("----------");

            // they are different in polymorphysm 
            Car[] cars = new Car[3];
            cars[0] = new Car();
            cars[1] = new ConvertibleCar();
            cars[2] = new Minivan();
            foreach (Car vehicle in cars)
            {
                Console.WriteLine("Car object: "
                    + vehicle.GetType());
                vehicle.DescribeCar();
                Console.WriteLine("----------");
            }
        }
    }
}
