﻿/*
 * 一個違反OCP的例子
 * 參考: Robert C. Martin, Agile Software Development: Principles, Patterns, 
 * and Practices, Pearson Education, 2003, p. 102.
 * 3/13/2009
 */

using System;

namespace OCPViolationExample
{
    class Program
    {
        static void Main(string[] args)
        {
            Point center;
            center.x = 15;
            center.y = 20;
            Point topLeft;
            topLeft.x = 30;
            topLeft.y = 40;
            Shape[] list = { new Circle(2, center), new Rectangle(3, 4, topLeft) };
            DrawAllShapes(list);
        }
        static void DrawAllShapes(Shape[] list)
        {
            int i;
            for (i = 0; i < list.Length; ++i)
            {
                Shape s = list[i];
                switch (s.type)
                {
                    case ShapeType.CIRCLE:
                        DrawCircle((Circle)s);
                        break;
                    case ShapeType.RECTANGLE:
                        DrawRectangle((Rectangle)s);
                        break;
                }
            }
        }
        static void DrawCircle(Circle c)
        {
            Console.WriteLine("Draw a circle");
        }
        static void DrawRectangle(Rectangle r)
        {
            Console.WriteLine("Draw a rectangle");
        }
    }

    enum ShapeType { CIRCLE, RECTANGLE }
    struct Point
    {
        public int x;
        public int y;
    }
    class Shape 
    {
        public ShapeType type;
        public Shape(ShapeType t)
        {
            type = t;
        }
    }
    class Circle : Shape
    {
        private int radius;
        private Point center;
        public Circle(int radius, Point center)
            :base(ShapeType.CIRCLE)
        {
            this.radius = radius;
            this.center = center;
        }
    }
    class Rectangle : Shape
    {
        private int width;
        private int height;
        private Point topLeft;
        public Rectangle(int width, int height, Point topLeft)
            : base(ShapeType.RECTANGLE)
        {
            this.width = width;
            this.height = height;
            this.topLeft = topLeft;
        }
    }
}
