﻿/*
 * 一個合乎ISP的設計
 * 參考: Robert C. Martin, Agile Software Development: Principles, Patterns, 
 * and Practices, Pearson Education, 2003, pp. 135-139.
 * 10/17/2008
 */

using System;

namespace TimedDoorSimulation
{
    interface TimerClient
    {
        void TimeOut();
    }
    class Timer
    {
        private int t;
        private int timeout;
        private TimerClient client;
        public Timer(int timeout, TimerClient client)
        {
            this.timeout = timeout;
            this.client = client;
            t = 0;
        }
        public void Advance()
        {
            ++t;
            if (t % timeout == 0)
            {
                client.TimeOut();
            }
        }
    }
    interface Door
    {
        void Lock();
        void Unlock();
        bool IsOpen();
    }
    enum DoorStatus
    {
        CLOSED = 0,
        OPEN = 1
    }
    class TimedDoor : Door, TimerClient
    {
        private DoorStatus status = DoorStatus.CLOSED;
        public bool IsOpen()
        {
            return (status == DoorStatus.OPEN);
        }
        public void Lock()
        {
            if (IsOpen()) status = DoorStatus.CLOSED;
        }
        public void Unlock()
        {
            if (!IsOpen()) status = DoorStatus.OPEN;
        }
        public void TimeOut()
        {
            Lock();
        }
    }
    class Program
    {
        static void Main(string[] args)
        {
            TimedDoor tDoor = new TimedDoor();
            int timeout = 10;
            Timer timer = new Timer(timeout, tDoor);
            int n;
            const int N = 20;
            tDoor.Unlock();
            for (n = 0; n <= N; ++n)
            {
                if (tDoor.IsOpen())
                {
                    Console.WriteLine("n = " + n + "\t tDoor is open");
                }
                else
                {
                    Console.WriteLine("n = " + n + "\t tDoor is closed");
                }
                timer.Advance();
            }
        }
    }
}
