﻿/*
 * 示範繼承架構中的建構式呼叫
 * 5/2/2007
 */

using System;

namespace UsingConstructorsForInheritance
{
    class Animal
    {
        private string species;
        public Animal()
        {
            Console.WriteLine("Animal()");
            species = "Animal";
        }
        public Animal(string s)
        {
            Console.WriteLine("Animal(" + s + ")");
            species = s;
        }
    }

    class Primate : Animal
    {
        private int heartCham;
        public Primate()
            : base()
        {
            Console.WriteLine("Primate()");
        }
        public Primate(int n)
            : base("Primate")
        {
            Console.WriteLine("Primate(" + n + ")");
            heartCham = n;
        }
    }

    class Human : Primate
    {
        public Human()
            : base(4)
        {
            Console.WriteLine("Human()");
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Animal slug = new Animal();
            Animal tweety = new Animal("canary");
            Primate godzilla = new Primate();
            Primate human = new Primate(4);
            Human jill = new Human();
        }
    }
}
