﻿/*
 * 二十一點遊戲, for GUI version
 * 11/21/2008
 */


using System;

namespace BlackJack_0_1G
{
    class Game
    {
        const int N_PLAYERS = 2;
        Deck deck;
        Player[] players = new Player[N_PLAYERS];

        public Game()
        {
            players[0] = new Player("Jeng");
            players[N_PLAYERS - 1] = new Dealer();
            deck = new Deck();
        }

        public void InitPlay(out PlayerInfo playerInfo, out PlayerInfo dealerInfo)
        {
            int i;
            // 第一輪發牌
            for (i = 0; i < N_PLAYERS; ++i)
            {
                players[i].SaveACard(deck.DealACard());
            }

            // 第二輪發牌
            for (i = 0; i < N_PLAYERS; ++i)
            {
                players[i].SaveACard(deck.DealACard());
            }
            playerInfo.name = players[0].Name;
            playerInfo.status = players[0].GetStatus();
            playerInfo.totalPoints = players[0].GetTotalPoints();
            playerInfo.cards = players[0].DumpCards();
            playerInfo.nCards = players[0].GetNCards();
            dealerInfo.name = players[N_PLAYERS - 1].Name;
            dealerInfo.status = players[N_PLAYERS - 1].GetStatus();
            dealerInfo.totalPoints = players[N_PLAYERS - 1].GetTotalPoints();
            dealerInfo.cards = players[N_PLAYERS - 1].DumpCards();
            dealerInfo.nCards = players[N_PLAYERS - 1].GetNCards();
        }

        public void ProcessPlayerRun(out PlayerInfo playerInfo)
        {
            players[0].SaveACard(deck.DealACard());
            playerInfo.name = players[0].Name;
            playerInfo.status = players[0].GetStatus();
            playerInfo.totalPoints = players[0].GetTotalPoints();
            playerInfo.cards = players[0].DumpCards();
            playerInfo.nCards = players[0].GetNCards();
        }

        public void ProcessDealerRun(out PlayerInfo dealerInfo)
        {
            while (players[N_PLAYERS - 1].WantOneMoreCard())
            {
                players[N_PLAYERS - 1].SaveACard(deck.DealACard());
            }
            dealerInfo.name = players[N_PLAYERS - 1].Name;
            dealerInfo.status = players[N_PLAYERS - 1].GetStatus();
            dealerInfo.totalPoints = players[N_PLAYERS - 1].GetTotalPoints();
            dealerInfo.cards = players[N_PLAYERS - 1].DumpCards();
            dealerInfo.nCards = players[N_PLAYERS - 1].GetNCards();
        }
    }
}
