﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace BlackJack_0_1G
{
    //***********************************
    public struct PlayerInfo
    {
        public string name;
        public Status status;
        public int totalPoints;
        public Card[] cards;
        public int nCards;
    }
    //***********************************

    public partial class MainForm : Form
    {

        //*******************************
        private Game game;
        private PlayerInfo playerInfo;
        private PlayerInfo dealerInfo;
        private Image image;
        private Graphics graphics;
        private bool inGame = false;
        //*******************************

        public MainForm()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //********************************************
            // "要牌"按鈕
            game.ProcessPlayerRun(out playerInfo);
            ShowInfo();
            CheckBlackJackOrBurst(playerInfo);
            CheckBlackJackOrBurst(dealerInfo);
            //********************************************
        }

        //************************************************
        private void ShowInfo()
        {
            int i;
            string fileName;
            graphics = CreateGraphics();
            for (i = 0; i < playerInfo.nCards; ++i)
            {
                fileName = "..\\PlayingCards\\" +
                           playerInfo.cards[i].Name() + ".jpg";
                image = Image.FromFile(fileName);
                graphics.DrawImage(image, 5+100*i, 220, 
                    85, 150);
            }
            for (i = 0; i < dealerInfo.nCards; ++i)
            {
                fileName = "..\\PlayingCards\\" +
                             dealerInfo.cards[i].Name() + ".jpg";
                image = Image.FromFile(fileName);
                graphics.DrawImage(image, 5 + 100 * i, 5,
                    85, 150);
            }
            label1.Text = dealerInfo.totalPoints.ToString();
            label2.Text = playerInfo.totalPoints.ToString();
            label11.Text = dealerInfo.name;
            label12.Text = playerInfo.name;
        }
        //************************************************

        private void button3_Click(object sender, EventArgs e)
        {
            //********************************************
            // "開始"按鈕
            inGame = true;
            game = new Game();
            game.InitPlay(out playerInfo, out dealerInfo);
            ShowInfo();
            CheckBlackJackOrBurst(playerInfo);
            CheckBlackJackOrBurst(dealerInfo);
            button3.Enabled = false; 
            button4.Enabled = true;
            //********************************************
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //********************************************
            // "停"按鈕
            game.ProcessDealerRun(out dealerInfo);
            ShowInfo();
            CheckBlackJackOrBurst(playerInfo);
            CheckBlackJackOrBurst(dealerInfo);
            if (playerInfo.status == Status.PASS &&
                dealerInfo.status == Status.PASS)
            {
                if (dealerInfo.totalPoints >= playerInfo.totalPoints)
                {
                    MessageBox.Show(dealerInfo.name + "勝" + playerInfo.name);
                }
                else
                {
                    MessageBox.Show(playerInfo.name + "勝" + dealerInfo.name);
                }
            }
            //********************************************
        }

        private void CheckBlackJackOrBurst(PlayerInfo info)
        {
            if (info.status == Status.BLACK_JACK)
            {
                MessageBox.Show(info.name + " 二十一點");
            }
            if (info.status == Status.BURST)
            {
                MessageBox.Show(info.name + " 爆!!!");
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            //********************************************
            // "清除"按鈕
            inGame = false;
            Invalidate();
            label1.Text = "0";
            label2.Text = "0";
            button4.Enabled = false;
            button3.Enabled = true;
            //********************************************
        }

        //************************************************
        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
            if (inGame)
            {
                ShowInfo();
            }
        }
        //************************************************
    }
}
