﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BlackJack_0_1G
{
    public enum Status
    {
        PASS = 0,
        BLACK_JACK = 1,
        BURST = 2
    }

    class StatusChecker
    {
        public static void DetermineStatusAndTotalPoints(Card[] hand, 
            int nCards,out Status status, out int totalPoints)
        {
            int[] point = new int[nCards];
            int i;
            int sum = 0;
            for (i = 0; i < nCards; ++i)
            {
                point[i] = Points(hand[i].rank);
                sum += point[i];
            }
            status = JudgeStatus(sum);
            totalPoints = sum;
            if (status != Status.PASS) return;

            bool isWithAce = false;

            // check if with Aces
            // needs considering only one Ace
            // to add 10 to it
            // since two Aces would be 22 points
            // and burst
            // if both are treated as 11 points
            for (i = 0; i < nCards; ++i)
            {
                if (point[i] == 1)
                {
                    isWithAce = true;
                    break;
                }
            }

            if (isWithAce)
            {
                sum += 10;
                if (sum == 21)
                {
                    status = Status.BLACK_JACK;
                }
                if (sum <= 21)
                {
                    totalPoints = sum;
                }
                // keep original totalPoints if sum > 21
            }
            return;
        }

        private static int Points(int rank)
        {
            int points = rank;
            if (rank > 10) points = 10;
            return points;
        }

        private static Status JudgeStatus(int sum)
        {
            Status status;
            if (sum == 21)
            {
                status = Status.BLACK_JACK;
            }
            else if (sum > 21)
            {
                status = Status.BURST;
            }
            else
            {
                status = Status.PASS;
            }
            return status;
        }
    }
}
