﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace DrawingAllShapesG
{
    public partial class MainForm : Form
    {
        //************************************************
        private bool started = false;
        Shape[] list = new Shape[2];
        //************************************************

        public MainForm()
        {
            InitializeComponent();

            //************************************************
            Point topLeft;
            topLeft.x = 30;
            topLeft.y = 40;
            Point center;
            center.x = 75;
            center.y = 70;
            list[0] = new Rectangle(100, 50, topLeft);
            list[1] = new Circle(50, center);
            //************************************************
        }

        private void button1_Click(object sender, EventArgs e)
        {
            //************************************************
            started = true;
            DrawContents();
            //************************************************
        }

        //************************************************
        private void DrawContents()
        {
            Graphics g = this.CreateGraphics();
            DrawAllShapes(list, g);
            g.Dispose();
        }

        private void DrawAllShapes(Shape[] list, Graphics g)
        {
            for (int i = 0; i < 2; ++i)
            {
                list[i].Draw(g);
            }
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
            if (started) DrawContents();
        }
        //************************************************
    }
}
