﻿using System;

namespace MVCExample
{
    public class Table
    {
        private int[,] data;
        public Table()
        {
            data = new int[1, 1];
            data[0, 0] = 0;
        }
        public Table(int[,] data)
        {
            this.data = data;
        }
        public int Element(int i, int j)
        {
            return data[i, j];
        }
        public int[] RowSum()
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int[] rowSum = new int[nRow];
            for (int i = 0; i < nRow; ++i)
            {
                rowSum[i] = 0;
                for (int j = 0; j < nCol; ++j)
                {
                    rowSum[i] += data[i, j];
                }
            }
            return rowSum;
        }
        public int[] ColSum()
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int[] colSum = new int[nCol];
            for (int j = 0; j < nCol; ++j)
            {
                colSum[j] = 0;
                for (int i = 0; i < nRow; ++i)
                {
                    colSum[j] += data[i, j];
                }
            }
            return colSum;
        }
        public int TotalSum()
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int totalSum = 0;
            for (int i = 0; i < nRow; ++i)
            {
                for (int j = 0; j < nCol; ++j)
                {
                    totalSum += data[i, j];
                }
            }
            return totalSum;
        }
    }
}
