﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace UsingDialogForm
{
    public partial class Output : Form
    {
        public Output()
        {
            InitializeComponent();
        }

        //*****************************************************
        public void DoComputation(int[,] t)
        {
		    int[,] table = t;
	        int[] rowSum = RowSum(t);
            int[] colSum = ColSum(t);
            int totalSum = TotalSum(t);
            richTextBox1.Text = "表格統計結果\n" +
                            " \t1\t2\t3\t總和\n" +
                            "1\t"+table[0,0].ToString()+"\t"+
                                  table[0,1].ToString()+"\t"+
                                  table[0,2].ToString()+"\t"+
                                  rowSum[0].ToString()+"\n"+
                            "2\t"+table[1,0].ToString()+"\t"+
                                  table[1,1].ToString()+"\t"+
                                  table[1,2].ToString()+"\t"+
                                  rowSum[1].ToString()+"\n"+
                            "總和\t"+colSum[0].ToString()+"\t"+
                                     colSum[1].ToString()+"\t"+
                                     colSum[2].ToString()+"\t"+
                                     totalSum.ToString()+"\n";       
        }

        private int[] RowSum(int[,] data)
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int[] rowSum = new int[nRow];
            for (int i = 0; i < nRow; ++i)
            {
                rowSum[i] = 0;
                for (int j = 0; j < nCol; ++j)
                {
                    rowSum[i] += data[i, j];
                }
            }
            return rowSum;
        }
        private int[] ColSum(int[,] data)
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int[] colSum = new int[nCol];
            for (int j = 0; j < nCol; ++j)
            {
                colSum[j] = 0;
                for (int i = 0; i < nRow; ++i)
                {
                    colSum[j] += data[i, j];
                }
            }
            return colSum;
        }
        private int TotalSum(int[,] data)
        {
            int nRow = data.GetUpperBound(0) + 1;
            int nCol = data.GetUpperBound(1) + 1;
            int totalSum = 0;
            for (int i = 0; i < nRow; ++i)
            {
                for (int j = 0; j < nCol; ++j)
                {
                    totalSum += data[i, j];
                }
            }
            return totalSum;
        }
        //****************************************************  

    }
}
