﻿/*
 * 表格處理
 * 4/20/2009
 */

using System;
using System.IO;

namespace UsingGUI
{
    public class Table
    {
        private int nRow;
        private int nCol;
        private int[,] data;
        public Table()
        {
            nRow = 1;
            nCol = 1;
            data = new int[1, 1];
            data[0, 0] = 0;
        }

        // 由檔案建立表格
        //
        // 例如:
        // +---------+---------+---------+
        // |    3    |    4    |    2    |
        // +---------+---------+---------+
        // |    5    |    7    |    6    |
        // +---------+---------+---------+
        //
        // 檔案格式為
        // 2,3
        // 3,4,2
        // 5,7,6
        public Table(string fileName)
        {
            StreamReader input = new
                    StreamReader(fileName);
            string line;
            string[] head = new string[2];

            line = input.ReadLine();
            head = line.Split(',');
            nRow = int.Parse(head[0]);
            nCol = int.Parse(head[1]);
            data = new int[nRow, nCol];

            string[] dataString = new string[nCol];
            int i;
            int j;
            for (i = 0; i < nRow; ++i)
            {
                line = input.ReadLine();
                dataString = line.Split(',');
                for (j = 0; j < nCol; ++j)
                {
                    data[i, j] = int.Parse(dataString[j]);
                }

            }
        }
        public int NRow
        {
            get { return nRow; }
        }
        public int NCol
        {
            get { return nCol; }
        }
        public int Element(int i, int j)
        {
            return data[i, j];
        }
        public int[] RowSum()
        {
            int[] rowSum = new int[nRow];
            for (int i = 0; i < nRow; ++i)
            {
                rowSum[i] = 0;
                for (int j = 0; j < nCol; ++j)
                {
                    rowSum[i] += data[i, j];
                }
            }
            return rowSum;
        }
        public int[] ColSum()
        {
            int[] colSum = new int[nCol];
            for (int j = 0; j < nCol; ++j)
            {
                colSum[j] = 0;
                for (int i = 0; i < nRow; ++i)
                {
                    colSum[j] += data[i, j];
                }
            }
            return colSum;
        }
        public int TotalSum()
        {
            int totalSum = 0;
            for (int i = 0; i < nRow; ++i)
            {
                for (int j = 0; j < nCol; ++j)
                {
                    totalSum += data[i, j];
                }
            }
            return totalSum;
        }

        public int[,] Content
        {
            get { return data; }
            set { 
                    data = value;
                    nRow = value.GetUpperBound(0) + 1;
                    nCol = value.GetUpperBound(1) + 1;
                }
        }
    }
}
