﻿/* 利用Euclid演算法找出兩數之最大公因數
 * 8/28/2009
 * 
 * Euclid演算法虛擬碼
 *  1. x = 較大的輸入值;
 *  2. y = 較小的輸入值;
 *  3. while( y不等於0)
 *     {
 *  3.1      remainder = x 除以y的餘數;
 *  3.2      x = y;
 *  3.3      y = remainder;
 *     }
 *  4. 最大公因數 = x;
 *
 * 測試
 *  1. 輸入 1, 5; 輸出 1
 *  2. 輸入 12, 18; 輸出 6
 *  3. 輸入 17, 13; 輸出 1
 */

using System;

namespace Euclid
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.Write("輸入第一個正整數: ");
            int x = Convert.ToInt32(Console.ReadLine());
            Console.Write("輸入第二個正整數: ");
            int y = Convert.ToInt32(Console.ReadLine());
            if (x < y) // x 較小時, 需交換x 與 y
            {
                int temp = x;
                x = y;
                y = temp;
            }
            int remainder;
            while (y != 0)
            {
                remainder = x % y;
                x = y;
                y = remainder;
            }
            Console.WriteLine("兩數的最大公因數為{0}", x);
        }
    }
}
