﻿/*
 * 以函式改寫最大公因數計算程式
 * 10/4/2009
 */

using System;
using System.Diagnostics;

namespace Euclid2
{
    class Program
    {
        static void Main(string[] args)
        {
            Debug.Assert(GCD( 1, 5 ) == 1);
            Debug.Assert(GCD( 12, 18 ) == 6);
            Debug.Assert(GCD(17, 13) == 1);

            Console.Write("輸入第一個正整數: ");
            int x = Convert.ToInt32(Console.ReadLine());
            Console.Write("輸入第二個正整數: ");
            int y = Convert.ToInt32(Console.ReadLine());
            Console.WriteLine("兩數的最大公因數為{0}", GCD(x, y));
        }

         /* 以Euclid演算法求最大公因數虛擬碼
          *  1  x = 較大的輸入值;
          *  2  y = 較小的輸入值;
          *  3  while( y不等於0)
          *     {
          *  3.1    remainder = x 除以y的餘數;
          *  3.2    x = y;
          *  3.3    y = remainder;
          *     }
          *  4  最大公因數 = x;
          */
        static int GCD(int x, int y)
        {
            if (x < y) Swap(ref x, ref y); // x 較小時, 需交換x 與 y
            int remainder;
            while (y != 0)
            {
                remainder = x % y;
                x = y;
                y = remainder;
            }
            return x;
        }

        // 交換兩個整數
        static void Swap(ref int x, ref int y)
        {
            int temp = x;
            x = y;
            y = temp;
        }
    }
}
