﻿/*
 * 示範陣列參數的傳遞
 * 10/9/2009
 */

using System;
using System.Diagnostics;

namespace PassingArray
{
    class Program
    {
        static void Main(string[] args)
        {
            int[] p = { 1, 2, 3, 4, 5 };
            int[] pCopy = p;
            Debug.Assert(pCopy == p);
            PassArrayElementByValue(p[2]);
            Debug.Assert(p[2] == 3);
            PassArrayElementByReference(ref p[2]);
            Debug.Assert(p[2] == 6);
            PassArrayElementAsOutParameter(out p[2]);
            Debug.Assert(p[2] == 3);
            PassArrayByValue(p);
            Debug.Assert( p[0] == 2 &&
                          p[1] == 4 &&
                          p[2] == 6 &&
                          p[3] == 8 &&
                          p[4] == 10 );
            Debug.Assert(p == pCopy);
            PassArrayByReference(ref p);
            Debug.Assert( p[0] == 7 &&
                          p[1] == 8 &&
                          p[2] == 9 );
            Debug.Assert(p != pCopy);
            PassArrayAsOutParameter(out p);
            Debug.Assert(  p[0] == 1 &&
                           p[1] == 2 &&
                           p[2] == 3 &&
                           p[3] == 4 &&
                           p[4] == 5);
        }
        static void PassArrayElementByValue(int x)
        {
            x *= 2;
        }
        static void PassArrayElementByReference(ref int x)
        {
            x *= 2;
        }
        static void PassArrayElementAsOutParameter(out int x)
        {
            x = 3;
        }
        static void PassArrayByValue(int[] a)
        {
            for (int i = 0; i < a.Length; ++i)
            {
                a[i] *= 2;
            }
            a = new int[] { 7, 8, 9 };
        }
        static void PassArrayByReference(ref int[] a)
        {
            for (int i = 0; i < a.Length; ++i)
            {
                a[i] *= 2;
            }
            a = new int[] { 7, 8, 9 };
        }
        static void PassArrayAsOutParameter(out int[] a)
        {
            a = new int[] { 1, 2, 3, 4, 5 };
        }
    }
}
