﻿/*
 * 顯示水平拋體運動軌跡
 * 10/1/2009
 * 
 * 虛擬碼
 * 1 Screen[0,0]~Screen[NY-1,NX-1]設為空白
 * 2 for(t=0; t<NT; ++t)
 *    {
 * 2.1   Screen[y, x] = ' '   
 * 2.2   x = HorizontalDistance(v0, t)
 * 2.3   y = VerticalDistance(g, t)
 * 2.4   Screen[y, x] = 'o'
 * 2.5   重新顯示Screen
 *    }
 * 
 * 虛擬碼 HorizontalDistance( v0, t )
 * 1 x = v0*t
 * 2 return x
 * 
 * 虛擬碼 VerticalDistance( g, t )
 * 1 y = 0.5*g*t*t
 * 2 return y
 * 
 */

using System;

namespace PlottingTrajectory
{
    class Program
    {
        static void Main(string[] args)
        {
            const int NX = 70;
            const int NY = 24;
            char[,] Screen = new char[NY, NX];
            int i;
            int j;
            for (i = 0; i < NY; ++i)
            {
                for(j=0; j<NX; ++j)
                {
                    Screen[i, j] = ' ';
                }
            }
            const int NT = 25;
            int t;
            int x = 0;
            int y = 0;
            const double v0 = 3.0;
            const double g = 0.1;

            for (t = 0; t < NT; ++t)
            {
                //Screen[y, x] = ' ';
                x = HorizontalDistance(v0, t);
                y = VerticalDistance(g, t);
                if (x >= NX || y >= NY) break;
                Screen[y, x] = 'o';
                Console.Clear();
                /*
                for (i = 0; i < NY; ++i)
                {
                    for (j = 0; j < NX; ++j)
                    {
                        Console.Write(Screen[i, j]);
                    }
                    Console.WriteLine();
                }
                 */
            }
            for (i = 0; i < NY; ++i)
            {
                for (j = 0; j < NX; ++j)
                {
                    Console.Write(Screen[i, j]);
                }
                Console.WriteLine();
            }
        }
        static int HorizontalDistance(double v0, int t)
        {
      
            double x = v0 * t;
            return (int) x;
        }
        static int VerticalDistance(double g, int t)
        {
            double y = 0.5 * g * t * t;
            return (int) y;
        }
    }
}
