﻿/*
 * 改寫程式Array2D
 * 以表格列平均及行平均示範
 * 傳回陣列的函式呼叫與宣告
 * 10/11/2009
 */

using System;

namespace ReturningArray
{
    class Program
    {
        static void Main(string[] args)
        {
            const int N_STUDENTS = 3;
            const int N_SUBJECTS = 2;
            string[] registerNumber = new string[N_STUDENTS];
            registerNumber[0] = "B645330";
            registerNumber[1] = "B645331";
            registerNumber[2] = "B645332";
            string[] subject = new string[N_SUBJECTS];
            subject[0] = "計算機概論";
            subject[1] = "計算機程式設計";
            int[,] score = new int[N_STUDENTS, N_SUBJECTS];
            score[0, 0] = 90;
            score[0, 1] = 84;
            score[1, 0] = 88;
            score[1, 1] = 86;
            score[2, 0] = 86;
            score[2, 1] = 92;

            double[] individualAverage = AverageOfEachRow(score);

            double[] subjectAverage = AverageOfEachColumn(score);

            for (int i = 0; i < N_STUDENTS; ++i)
            {
                Console.WriteLine("{0}: 兩科平均成績 {1}",
                    registerNumber[i], individualAverage[i]);
            }
            for (int j = 0; j < N_SUBJECTS; ++j)
            {
                Console.WriteLine("{0}: 全班平均成績 {1}",
                    subject[j], subjectAverage[j]);
            }
        }

        static double[] AverageOfEachColumn(int[,] table)
        {
            int nColumns = table.GetUpperBound(1) + 1;
            double[] average = new double[nColumns];
            int nRows = table.GetUpperBound(0) + 1;
            for (int j = 0; j < nColumns; j++)
            {
                int sum = 0;
                for (int i = 0; i < nRows; i++)
                {
                    sum += table[i, j];
                }
                average[j] = (double)sum / nRows;
            }
            return average;
        }

        static double[] AverageOfEachRow(int[,] table)
        {
            int nRows = table.GetUpperBound(0)+1;
            double[] average = new double[nRows];
            int nColumns = table.GetUpperBound(1)+1;
            for (int i = 0; i < nRows ; i++)
            {
                int sum = 0;
                for (int j = 0; j < nColumns; j++)
                {
                    sum += table[i, j];
                }
                average[i] = (double)sum / nColumns;
            }
            return average;
        }            
    }
}
