﻿using System;
using System.Diagnostics;

namespace BlackJack_0_0_1
{
    enum Suit
    {
        CLUB = 0,
        DIAMOND = 1,
        HEART = 2,
        SPADE = 3
    }
    class Program
    {
        static void Main(string[] args)
        {
            Debug.Assert(TestScenario_1_OK());
        }
        static bool TestScenario_1_OK()
        {
            Suit[] humanPlayerHandSuit = new Suit[2];
            int[] humanPlayerHandRank = new int[2];
            Suit[] computerPlayerHandSuit = new Suit[1];
            int[] computerPlayerHandRank = new int[1];
            humanPlayerHandSuit[0] = Suit.SPADE;
            humanPlayerHandRank[0] = 1;
            computerPlayerHandSuit[0] = Suit.HEART;
            computerPlayerHandRank[0] = 11;
            humanPlayerHandSuit[1] = Suit.DIAMOND;
            humanPlayerHandRank[1] = 10;
            return IsBlackJack(humanPlayerHandRank);
        }
        static bool IsBlackJack(int[] handRank)
        {
            int point0 = Points(handRank[0]);
            int point1 = Points(handRank[1]);
            bool isBlackJack =
                (point0 + point1 == 21);
            if (!isBlackJack && point0 == 1)
            {
                point0 = 11;
                isBlackJack =
                (point0 + point1 == 21);
            }
            if (!isBlackJack && point1 == 1)
            {
                point1 = 11;
                isBlackJack =
                (point0 + point1 == 21);
            }
            return isBlackJack;
        }
        static int Points(int rank)
        {
            int points = rank;
            if (rank > 10) points = 10;
            return points;
        }
    }
}
