﻿using System;
using System.Diagnostics;

namespace BlackJack_0_0_2
{
    enum Suit
    {
        CLUB = 0,
        DIAMOND = 1,
        HEART = 2,
        SPADE = 3
    }

    enum Status
    {
        PASS = 0,
        BLACK_JACK = 1,
        BURST = 2
    }

    class Program
    {
        static void Main(string[] args)
        {
            Debug.Assert(TestScenario_1_OK(),
                "Scenario 1 test failed");
            Debug.Assert(TestScenario_2_OK(),
                "Scenario 2 test failed");
            Debug.Assert(TestScenario_3_OK(),
                "Scenario 3 test failed");
            Debug.Assert(TestScenario_4_OK(),
                "Scenario 4 test failed");
            Debug.Assert(TestScenario_5_OK(),
                "Scenario 5 test failed");
            Debug.Assert(TestScenario_6_OK(),
                "Scenario 6 test failed");
        }
        static bool TestScenario_1_OK()
        {
            Suit[] deckSuit = new Suit[3];
            int[] deckRank = new int[3];
            int top;
            PrepareDeck_1(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[2];
            int[] humanPlayerHandRank = new int[2];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[1];
            int[] computerPlayerHandRank = new int[1];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit,
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank, 
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.BLACK_JACK &&
                    computerPlayerStatus == Status.PASS);
        }
        static void PrepareDeck_1(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.SPADE;
            deckRank[0] = 1;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 11;
            deckSuit[2] = Suit.DIAMOND;
            deckRank[2] = 10;
            top = 0;
        }
        static void DealACard(Suit[] deckSuit, int[] deckRank, ref int top, 
            Suit[] suit, int[] rank, ref int nCards)
        {
            suit[nCards] = deckSuit[top];
            rank[nCards] = deckRank[top];
            ++top;
            ++nCards;
        }

        static Status GetStatus(int[] handRank, int nCards, 
            out int totalPoints)
        {
            int[] point = new int[nCards];
            int i;
            int sum = 0;
            for (i = 0; i < nCards; ++i)
            {
                point[i] = Point(handRank[i]);
                sum += point[i];
            }
            Status status = JudgeStatus(sum);
            totalPoints = sum;
            if (status != Status.PASS) return status;

            // check if with Aces
            // needs considering only one Ace
            // to add 10 to it
            // since two Aces would be 22 points
            // and burst
            // if both are treated as 11 points
            bool isWithAce = false;
            for (i = 0; i < nCards; ++i)
            {
                if (point[i] == 1)
                {
                    isWithAce = true;
                    break;
                }
            }
            if (isWithAce)
            {
                sum += 10;
                if (sum == 21)
                {
                    status = Status.BLACK_JACK;
                }
                if (sum <= 21)
                {
                    totalPoints = sum;
                }
                // keep original totalPoints if sum > 21
            }
            return status;
        }
        static int Point(int rank)
        {
            int point = rank;
            if (rank > 10) point = 10;
            return point;
        }
        static Status JudgeStatus(int sum)
        {
            Status status;
            if (sum == 21)
            {
                status = Status.BLACK_JACK;
            }
            else if (sum > 21)
            {
                status = Status.BURST;
            }
            else
            {
                status = Status.PASS;
            }
            return status;
        }
        static bool TestScenario_2_OK()
        {
            Suit[] deckSuit = new Suit[4];
            int[] deckRank = new int[4];
            int top;
            PrepareDeck_2(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[2];
            int[] humanPlayerHandRank = new int[2];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[2];
            int[] computerPlayerHandRank = new int[2];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, 
                computerPlayerHandSuit, computerPlayerHandRank,
                ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, 
                computerPlayerHandSuit, computerPlayerHandRank,
                ref nComputerPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(
                computerPlayerHandRank, nComputerPlayerHandCards,
                out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.PASS &&
                    computerPlayerStatus == Status.BLACK_JACK);
        }
        static void PrepareDeck_2(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.CLUB;
            deckRank[0] = 3;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 11;
            deckSuit[2] = Suit.SPADE;
            deckRank[2] = 10;
            deckSuit[3] = Suit.DIAMOND;
            deckRank[3] = 1;
            top = 0;
        }
        static bool TestScenario_3_OK()
        {
            Suit[] deckSuit = new Suit[5];
            int[] deckRank = new int[5];
            int top;
            PrepareDeck_3(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[3];
            int[] humanPlayerHandRank = new int[3];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[2];
            int[] computerPlayerHandRank = new int[2];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank, 
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.BLACK_JACK &&
                    computerPlayerStatus == Status.PASS);
        }
        static void PrepareDeck_3(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.SPADE;
            deckRank[0] = 8;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 11;
            deckSuit[2] = Suit.DIAMOND;
            deckRank[2] = 7;
            deckSuit[3] = Suit.SPADE;
            deckRank[3] = 2;
            deckSuit[4] = Suit.CLUB;
            deckRank[4] = 6;
            top = 0;
        }
        static bool TestScenario_4_OK()
        {
            Suit[] deckSuit = new Suit[5];
            int[] deckRank = new int[5];
            int top;
            PrepareDeck_4(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[3];
            int[] humanPlayerHandRank = new int[3];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[2];
            int[] computerPlayerHandRank = new int[2];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank, 
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.BURST &&
                    computerPlayerStatus == Status.PASS);
        }
        static void PrepareDeck_4(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.SPADE;
            deckRank[0] = 8;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 5;
            deckSuit[2] = Suit.DIAMOND;
            deckRank[2] = 8;
            deckSuit[3] = Suit.SPADE;
            deckRank[3] = 9;
            deckSuit[4] = Suit.CLUB;
            deckRank[4] = 6;
            top = 0;
        }
        static bool TestScenario_5_OK()
        {
            Suit[] deckSuit = new Suit[5];
            int[] deckRank = new int[5];
            int top;
            PrepareDeck_5(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[2];
            int[] humanPlayerHandRank = new int[2];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[3];
            int[] computerPlayerHandRank = new int[3];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank, 
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.PASS &&
                    computerPlayerStatus == Status.PASS &&
                    humanPlayerTotalPoints < computerPlayerTotalPoints);
        }
        static void PrepareDeck_5(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.SPADE;
            deckRank[0] = 8;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 5;
            deckSuit[2] = Suit.DIAMOND;
            deckRank[2] = 8;
            deckSuit[3] = Suit.SPADE;
            deckRank[3] = 9;
            deckSuit[4] = Suit.CLUB;
            deckRank[4] = 6;
            top = 0;
        }
        static bool TestScenario_6_OK()
        {
            Suit[] deckSuit = new Suit[5];
            int[] deckRank = new int[5];
            int top;
            PrepareDeck_6(deckSuit, deckRank, out top);
            Suit[] humanPlayerHandSuit = new Suit[2];
            int[] humanPlayerHandRank = new int[2];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[3];
            int[] computerPlayerHandRank = new int[3];
            int nComputerPlayerHandCards = 0;
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit, 
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit, 
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            int humanPlayerTotalPoints;
            int computerPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank, 
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank, 
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            return (humanPlayerStatus == Status.PASS &&
                    computerPlayerStatus == Status.BURST);
        }
        static void PrepareDeck_6(Suit[] deckSuit, int[] deckRank, out int top)
        {
            deckSuit[0] = Suit.SPADE;
            deckRank[0] = 8;
            deckSuit[1] = Suit.HEART;
            deckRank[1] = 5;
            deckSuit[2] = Suit.DIAMOND;
            deckRank[2] = 8;
            deckSuit[3] = Suit.SPADE;
            deckRank[3] = 9;
            deckSuit[4] = Suit.CLUB;
            deckRank[4] = 8;
            top = 0;
        }
    }
}
