﻿/*
 * 函式導向二十一點模擬程式v0.1
 * skj  11/23/2009
 */

using System;
using System.Diagnostics;

namespace BlackJack_0_1
{
    enum Suit
    {
        CLUB = 0,
        DIAMOND = 1,
        HEART = 2,
        SPADE = 3
    }

    enum Status
    {
        PASS = 0,
        BLACK_JACK = 1,
        BURST = 2
    }

    class Program
    {
        static void Main(string[] args)
        {
            Debug.Assert(TestDeck_OK(),
                 "Deck test failed");
            Console.WriteLine();
            Console.WriteLine("21點遊戲開始");
            RunGame();
        }
        static bool TestDeck_OK()
        {
            Suit[] deckSuit = new Suit[52];
            int[] deckRank = new int[52];
            int top;
            PrepareDeck(deckSuit, deckRank, out top);
            Suit[] cardsSuit = new Suit[52];
            int[] cardsRank = new int[52];
            int nCards = 0;
            int i;
            for (i = 0; i < 52; ++i)
            {
                DealACard(deckSuit, deckRank, ref top, cardsSuit,
                    cardsRank, ref nCards);
            }
            int[] nSuit = new int[4];
            int s;
            for (s = 0; s < 4; ++s)
            {
                nSuit[s] = 0;
            }
            int[] nRank = new int[13];
            int r;
            for (r = 0; r < 13; ++r)
            {
                nRank[r] = 0;
            }
            for (i = 0; i < 52; ++i)
            {
                switch (cardsSuit[i])
                {
                    case Suit.CLUB:
                        nSuit[0]++;
                        break;
                    case Suit.DIAMOND:
                        nSuit[1]++;
                        break;
                    case Suit.HEART:
                        nSuit[2]++;
                        break;
                    case Suit.SPADE:
                        nSuit[3]++;
                        break;
                    default:
                        break;
                }
                nRank[cardsRank[i] - 1]++;
            }
            bool suit_OK = true;
            for (s = 0; s < 4; s++)
            {
                if (nSuit[s] != 13)
                {
                    suit_OK = false;
                    break;
                }
            }
            bool rank_OK = true;
            for (r = 0; r < 13; r++)
            {
                if (nRank[r] != 4)
                {
                    rank_OK = false;
                    break;
                }
            }
            return suit_OK && rank_OK;
        }
        static void RunGame()
        {
            Suit[] deckSuit = new Suit[52];
            int[] deckRank = new int[52];
            int top;
            PrepareDeck(deckSuit, deckRank, out top);

            // a player can have at most 11 cards
            // {A, A, A, A, 2, 2, 2, 2, 3, 3, 3}
            // for not burst or BlackJack
            Suit[] humanPlayerHandSuit = new Suit[11];
            int[] humanPlayerHandRank = new int[11];
            int nHumanPlayerHandCards = 0;
            Suit[] computerPlayerHandSuit = new Suit[11];
            int[] computerPlayerHandRank = new int[11];
            int nComputerPlayerHandCards = 0;

            // 第一輪發牌
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit,
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            int humanPlayerTotalPoints;
            Status humanPlayerStatus = GetStatus(humanPlayerHandRank,
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            DumpHand("玩家", humanPlayerHandSuit, humanPlayerHandRank,
                nHumanPlayerHandCards, humanPlayerTotalPoints);
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit,
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            int computerPlayerTotalPoints;
            Status computerPlayerStatus = GetStatus(computerPlayerHandRank,
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            DumpHand("電腦", computerPlayerHandSuit, computerPlayerHandRank,
                nComputerPlayerHandCards, computerPlayerTotalPoints);


            // 第二輪發牌
            DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit,
                humanPlayerHandRank, ref nHumanPlayerHandCards);
            humanPlayerStatus = GetStatus(humanPlayerHandRank,
                nHumanPlayerHandCards, out humanPlayerTotalPoints);
            DumpHand("玩家", humanPlayerHandSuit, humanPlayerHandRank,
                nHumanPlayerHandCards, humanPlayerTotalPoints);
            if (IsBlackJackOrBurst(humanPlayerStatus)) return;
            DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit,
                computerPlayerHandRank, ref nComputerPlayerHandCards);
            computerPlayerStatus = GetStatus(computerPlayerHandRank,
                nComputerPlayerHandCards, out computerPlayerTotalPoints);
            DumpHand("電腦", computerPlayerHandSuit, computerPlayerHandRank,
                nComputerPlayerHandCards, computerPlayerTotalPoints);
            if (IsBlackJackOrBurst(computerPlayerStatus)) return;

            // 開始要牌計牌
            while (humanPlayerStatus == Status.PASS &&
                   HumanPlayerWantsOneMoreCard() &&
                   top < 51)
            {
                DealACard(deckSuit, deckRank, ref top, humanPlayerHandSuit,
                    humanPlayerHandRank, ref nHumanPlayerHandCards);
                humanPlayerStatus = GetStatus(humanPlayerHandRank,
                    nHumanPlayerHandCards, out humanPlayerTotalPoints);
                DumpHand("玩家", humanPlayerHandSuit, humanPlayerHandRank,
                    nHumanPlayerHandCards, humanPlayerTotalPoints);
                if (IsBlackJackOrBurst(humanPlayerStatus)) return;
            }


            while (computerPlayerStatus == Status.PASS &&
                   ComputerPlayerWantsOneMoreCard(
                        computerPlayerTotalPoints) &&
                   top < 51)
            {
                DealACard(deckSuit, deckRank, ref top, computerPlayerHandSuit,
                    computerPlayerHandRank, ref nComputerPlayerHandCards);
                computerPlayerStatus = GetStatus(computerPlayerHandRank,
                    nComputerPlayerHandCards, out computerPlayerTotalPoints);
                DumpHand("電腦", computerPlayerHandSuit,
                    computerPlayerHandRank, nComputerPlayerHandCards,
                    computerPlayerTotalPoints);
                if (IsBlackJackOrBurst(computerPlayerStatus)) return;
            }
            // 計點分勝負
            if (computerPlayerTotalPoints >= humanPlayerTotalPoints)
            {
                Console.WriteLine("電腦勝");
            }
            else
            {
                Console.WriteLine("玩家勝");
            }
        }
        static void PrepareDeck(Suit[] deckSuit, int[] deckRank,
            out int top)
        {
            Random rand = new Random();
            int i;
            bool[] used = new bool[52];
            for (i = 0; i < 52; ++i)
            {
                used[i] = false;
            }
            int pos; // position in the table
            int s;
            for (i = 0; i < 52; ++i)
            {
                pos = rand.Next() % 52;

                // search for un-used position
                while (used[pos])
                {
                    ++pos;
                    pos = pos % 52;
                }
                s = pos / 13;
                switch (s)
                {
                    case 0:
                        deckSuit[i] = Suit.CLUB;
                        break;
                    case 1:
                        deckSuit[i] = Suit.DIAMOND;
                        break;
                    case 2:
                        deckSuit[i] = Suit.HEART;
                        break;
                    case 3:
                        deckSuit[i] = Suit.SPADE;
                        break;
                    default:
                        break;
                }
                deckRank[i] = pos % 13 + 1;
                used[pos] = true;
            }
            top = 0;
        }
        static void DealACard(Suit[] deckSuit, int[] deckRank,
            ref int top, Suit[] suit, int[] rank, ref int nCards)
        {
            suit[nCards] = deckSuit[top];
            rank[nCards] = deckRank[top];
            ++top;
            ++nCards;
        }
        static void DumpHand(string name, Suit[] handSuit, int[] handRank,
            int nCards, int totalPoints)
        {
            Console.Write(name + " 牌: ");
            int i;
            for (i = 0; i < nCards; ++i)
            {
                DumpCard(handSuit[i], handRank[i]);
                Console.Write("\t");
                if ((i + 1) % 5 == 0)
                    Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine(" 總點數: " + totalPoints);
        }
        static bool HumanPlayerWantsOneMoreCard()
        {
            Console.Write("要再一張牌嗎? (y/n) ");
            string answer = Console.ReadLine();
            return (answer == "Y" || answer == "y");
        }
        static bool ComputerPlayerWantsOneMoreCard(int totalPoints)
        {
            return (totalPoints < 17);
        }
        static void DumpCard(Suit suit, int rank)
        {
            string[] ranks = { 
                  "A", "2", "3", "4", "5",
                  "6", "7", "8", "9", "10",
                  "J", "Q", "K" };
            switch (suit)
            {
                case Suit.CLUB:
                    Console.Write("c" +
                        ranks[rank - 1]);
                    break;
                case Suit.DIAMOND:
                    Console.Write("d" +
                        ranks[rank - 1]);
                    break;
                case Suit.HEART:
                    Console.Write("h" +
                    ranks[rank - 1]);
                    break;
                case Suit.SPADE:
                    Console.Write("s" +
                    ranks[rank - 1]);
                    break;
                default:
                    break;
            }
        }
        static Status GetStatus(int[] handRank, int nCards, out int totalPoints)
        {
            int[] point = new int[nCards];
            int i;
            int sum = 0;
            for (i = 0; i < nCards; ++i)
            {
                point[i] = Point(handRank[i]);
                sum += point[i];
            }
            Status status = JudgeStatus(sum);
            totalPoints = sum;
            if (status != Status.PASS) return status;

            // check if with Aces
            // needs considering only one Ace
            // to add 10 to it
            // since two Aces would be 22 points
            // and burst
            // if both are treated as 11 points
            bool isWithAce = false;
            for (i = 0; i < nCards; ++i)
            {
                if (point[i] == 1)
                {
                    isWithAce = true;
                    break;
                }
            }
            if (isWithAce)
            {
                sum += 10;
                if (sum == 21)
                {
                    status = Status.BLACK_JACK;
                }
                if (sum <= 21)
                {
                    totalPoints = sum;
                }
                // keep original totalPoints if sum > 21
            }
            return status;
        }
        static int Point(int rank)
        {
            int point = rank;
            if (rank > 10) point = 10;
            return point;
        }
        static Status JudgeStatus(int sum)
        {
            Status status;
            if (sum == 21)
            {
                status = Status.BLACK_JACK;
            }
            else if (sum > 21)
            {
                status = Status.BURST;
            }
            else
            {
                status = Status.PASS;
            }
            return status;
        }
        static bool IsBlackJackOrBurst(Status playerStatus)
        {
            bool isBlackJack = false;
            if (playerStatus == Status.BLACK_JACK)
            {
                isBlackJack = true;
                Console.WriteLine(" BlackJack!!!");
            }
            bool isBurst = false;
            if (playerStatus == Status.BURST)
            {
                isBurst = true;
                Console.WriteLine(" 爆!!!");
            }
            return (isBlackJack || isBurst);
        }
    }
}