﻿/*
 * 模擬時鐘
 * skj  12/21/2009
 */

using System;

namespace ClockSimulation
{
    class Clock
    {
        private int hour = 0;  // 0~23
        private int minute = 0;// 0~59
        private int second = 0;// 0~59

        // 24小時制
        public void SetTime( int h, int m, int s )
        {
            SetValues( h, m, s );
        }

        // 上下午制
        public void SetTime( int h, int m, int s, string aAMPM )
        {
            SetValues( h, m, s );
            if( aAMPM == "PM" && h != 12 ) hour += 12;
        }
        private void SetValues( int h, int m, int s )
        {
            hour = h;
            minute = m;
            second = s;
        }

        // 24小時制
        public void GetTime(out int h, out int m, out int s)
        {
            h = hour;
            m = minute;
            s = second;
        }

        // 上下午制
        public void GetTime(out int h, out int m, out int s, 
            out string aAMPM)
        {
            h = hour;
            if (hour > 12) h -= 12;
            m = minute;
            s = second;
            if (hour >= 12) aAMPM = "PM";
            else aAMPM = "AM";
        }

        // 前進一秒
        public void Tick()
        {
            second++;
            if (second == 60)
            {
                second = 0;
                minute++;
            }
            if (minute == 60)
            {
                minute = 0;
                hour++;
            }
            if (hour == 24) hour = 0;
        }
    }
}
