﻿using System;

namespace CountingRectangles
{
    class Rectangle
    {
        private int width;
        private int height;
        private static int nConstructed = 0;
        public Rectangle()
        {
            width = 1;
            height = 1;
            nConstructed++;
        }
        public Rectangle(int width, int height)
        {
            this.width = width;
            this.height = height;
            nConstructed++;
        }
        public Rectangle(int width)
        {
            this.width = width;
            this.height = width;
            nConstructed++;
        }
        public int Width
        {
            get { return width; }
        }
        public int Height
        {
            get { return height; }
        }
        public void Rotate()
        {
            int temp = width;
            width = height;
            height = temp;
        }
        public static int GetNConstructed()
        {
            return nConstructed;
        }
        public static int NRectangles
        {
            get { return nConstructed; }
        }
    }
}
