﻿/*
 * 模擬擲兩顆骰, 統計各點數出現次數比例
 * skj  1/11/2010
 */

using System;

namespace DiceSimulation2
{
    class Program
    {
        static void Main(string[] args)
        {
            int[] count = { 0, 0, 0, 0, 0, 0,
                            0, 0, 0, 0, 0 };
            int N = 12000;
            const int SEED_1 = 168;
            Dice dice1 = new Dice(SEED_1);
            const int SEED_2 = 777;
            Dice dice2 = new Dice(SEED_2);
            for (int i = 0; i < N; ++i)
            {
                dice1.Toss();
                dice2.Toss();
                count[dice1.FaceValue + dice2.FaceValue - 2]++;
            }
            double[] probability = { 1.0/36.0, 2.0/36.0, 
                                     3.0/36.0, 4.0/36.0, 
                                     5.0/36.0, 6.0/36.0,
                                     5.0/36.0, 4.0/36.0, 
                                     3.0/36.0, 2.0/36.0, 
                                     1.0/36.0 };
            for (int k = 0; k < 11; ++k)
            {
                Console.WriteLine(
                    " The frequency ratio of {0} is {1:F6}."+
                    " Theoretical probability is {2:F6}",
                    k + 2, count[k]/(double) N, probability[k]);
            }
        }
    }
}
