﻿using System;

namespace PoemDataBase
{
    class DataBase
    {
        private Poem[] poem;
        public DataBase()
        {
            poem = null;
        }
        public DataBase(Poem[] poem)
        {
            this.poem = poem;
        }
        public void Process()
        {
            ShowHeading();
            while (true)
            {
                int request = GetRequest();
                if (request == 0) break;
                if (request == 1) ProcessQueryByTitle();
                if (request == 2) ProcessQueryByAuthor();
            }
        }
        private void ShowHeading()
        {
            Console.WriteLine(
                "******唐詩三百首五言絕句資料庫******");
        }
        private int GetRequest()
        {
            Console.WriteLine("選擇");
            Console.WriteLine("0. 結束");
            Console.WriteLine("1. 以詩題查詢");
            Console.WriteLine("2. 以詩人姓名查詢");
            int request = int.Parse(
                Console.ReadLine());
            return request;
        }
        private void ProcessQueryByTitle()
        {
            Console.Write("輸入詩題: ");
            string title = Console.ReadLine();
            for (int i = 0; i < poem.Length; ++i)
            {
                if (poem[i].Title == title)
                {
                    Console.WriteLine(
                        poem[i].Title + "\t" + 
                        poem[i].Author);
                    Console.WriteLine(poem[i].Verse);
                }
            }
            Console.WriteLine();
        }
        private void ProcessQueryByAuthor()
        {
            Console.Write("輸入詩人姓名: ");
            string poet = Console.ReadLine();
            for (int i = 0; i < poem.Length; ++i)
            {
                if (poem[i].Author == poet)
                {
                    Console.WriteLine(
                        poem[i].Title + "\t" +
                        poem[i].Author);
                    Console.WriteLine(poem[i].Verse);
                }
            }
            Console.WriteLine();
        }
    }
}
