﻿/*
 * 二十一點遊戲
 * 主控台遊戲版本
 * 4/19/2009
 */

using System;

namespace BlackJack_0_0_3
{
    class Game
    {
        private Deck deck;
        private HumanPlayer player = new HumanPlayer();
        private ComputerPlayer computer =
            new ComputerPlayer();
        public void Run()
        {
            deck = new Deck();
            Play();
        }
        public void Run(int seed)
        {
            deck = new Deck(seed);
            Play();
        }
        private void Play()
        {
            player.SaveACard(deck.DealACard());
            player.Dump();
            computer.SaveACard(deck.DealACard());
            computer.Dump();
            player.SaveACard(deck.DealACard());
            player.Dump();
            if (IsBlackJackOrBurst()) return;
            computer.SaveACard(deck.DealACard());
            computer.Dump();
            if (IsBlackJackOrBurst()) return;
            while (player.GetStatus() == Status.PASS
                && player.WantOneMoreCard()
                && deck.HasMoreCard())
            {
                player.SaveACard(deck.DealACard());
                player.Dump();
            }
            if (IsBlackJackOrBurst()) return;
            while (
              computer.GetStatus() == Status.PASS &&
              computer.WantOneMoreCard() &&
              deck.HasMoreCard())
            {
                computer.SaveACard(deck.DealACard());
                computer.Dump();
            }
            if (IsBlackJackOrBurst()) return;
            Console.WriteLine("比大小分勝負");
            player.Dump();
            computer.Dump();
            if (IsBlackJackOrBurst()) return;
            if (computer.GetTotalPoints() >=
                player.GetTotalPoints())
            {
                Console.WriteLine("電腦勝");
            }
            else
            {
                Console.WriteLine("玩家勝");
            }
        }
        private bool IsBlackJackOrBurst()
        {
            bool isBlackJack = false;
            if (player.GetStatus() == Status.BLACK_JACK)
            {
                isBlackJack = true;
                Console.WriteLine(
                "玩家 BlackJack!!!");
            }
            if (computer.GetStatus() == Status.BLACK_JACK)
            {
                isBlackJack = true;
                Console.WriteLine(
                "電腦 BlackJack!!!");
            }
            bool isBurst = false;
            if (player.GetStatus() == Status.BURST)
            {
                isBurst = true;
                Console.WriteLine("玩家爆!!!");
            }
            if (
               computer.GetStatus() == Status.BURST)
            {
                isBurst = true;
                Console.WriteLine("電腦爆!!!");
            }
            return (isBlackJack || isBurst);
        }
    }
}
