﻿/*
 * 模擬玩家
 * 加入函式WantACard與Dump
 * 4/19/2010
 */

using System;

namespace BlackJack_0_0_3
{
    public enum Status
    {
        PASS = 0,
        BLACK_JACK = 1,
        BURST = 2
    }

    class HumanPlayer
    {
        // a player can have at most 11 cards
        // {A, A, A, A, 2, 2, 2, 2, 3, 3, 3}
        // for not burst or BlackJack
        private Card[] hand = new Card[11];
        private int nCards;
        private Status status;
        private int totalPoints;
        public HumanPlayer()
        {
            nCards = 0;
        }
        public void SaveACard(Card card)
        {
            hand[nCards++] = card;
            SetStatus();
        }
        public Status GetStatus()
        {
            return status;
        }
        public int GetTotalPoints()
        {
            return totalPoints;
        }
        private void SetStatus()
        {
            int[] point = new int[nCards];
            int i;
            int sum = 0;
            for (i = 0; i < nCards; ++i)
            {
                point[i] = Points(hand[i].rank);
                sum += point[i];
            }
            status = JudgeStatus(sum);
            totalPoints = sum;
            if (status != Status.PASS) return;

            bool isWithAce = false;

            // check if with Aces
            // needs considering only one Ace
            // to add 10 to it
            // since two Aces would be 22 points
            // and burst
            // if both are treated as 11 points
            for (i = 0; i < nCards; ++i)
            {
                if (point[i] == 1)
                {
                    isWithAce = true;
                    break;
                }
            }

            if (isWithAce)
            {
                sum += 10;
                if (sum == 21)
                {
                    status = Status.BLACK_JACK;
                }
                if (sum <= 21)
                {
                    totalPoints = sum;
                }
                // keep original totalPoints if sum > 21
            }
        }
        private int Points(int rank)
        {
            int points = rank;
            if (rank > 10) points = 10;
            return points;
        }
        private Status JudgeStatus(int sum)
        {
            Status status;
            if (sum == 21)
            {
                status = Status.BLACK_JACK;
            }
            else if (sum > 21)
            {
                status = Status.BURST;
            }
            else
            {
                status = Status.PASS;
            }
            return status;
        }
        public bool WantOneMoreCard()
        {
            Console.Write("要再一張牌嗎? (y/n) ");
            string answer = Console.ReadLine();
            return (answer == "Y" || answer == "y");
        }
        public void Dump()
        {
            int i;
            Console.Write("玩家牌: ");
            for (i = 0; i < nCards; ++i)
            {
                hand[i].Dump();
                Console.Write("\t");
                if ((i + 1) % 5 == 0)
                    Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine("玩家總點數: " +
                totalPoints);
        }

    }
}
