﻿/*
 * 模擬電腦莊家
 * 4/19/2010
 */

using System;

namespace BlackJack_0_0_4
{
    class ComputerPlayer
    {
        // a player can have at most 11 cards
        // {A, A, A, A, 2, 2, 2, 2, 3, 3, 3}
        // for not burst or BlackJack
        private Card[] hand = new Card[11];
        private int nCards;
        private Status status;
        private int totalPoints;
        public ComputerPlayer()
        {
            nCards = 0;
        }
        public void SaveACard(Card card)
        {
            hand[nCards++] = card;
            StatusChecker.DetermineStatusAndTotalPoints(
                hand, nCards, out status,
                out totalPoints);
        }
        public Status GetStatus()
        {
            return status;
        }
        public int GetTotalPoints()
        {
            return totalPoints;
        }
        public bool WantOneMoreCard()
        {
            return (totalPoints < 17);
        }
        public void Dump()
        {
            int i;
            Console.Write("電腦牌: ");
            for (i = 0; i < nCards; ++i)
            {
                hand[i].Dump();
                Console.Write("\t");
                if ((i + 1) % 5 == 0)
                    Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine(
                "電腦總點數: " + totalPoints);
        }
    }
}
