﻿/*
 * 模擬玩家
 * 4/23/2010
 */

using System;

namespace BlackJack_0_0_4
{
    class HumanPlayer
    {
        // a player can have at most 11 cards
        // {A, A, A, A, 2, 2, 2, 2, 3, 3, 3}
        // for not burst or BlackJack
        private Card[] hand = new Card[11];
        private int nCards;
        private Status status;
        private int totalPoints;
        public HumanPlayer()
        {
            nCards = 0;
        }
        public void SaveACard(Card card)
        {
            hand[nCards++] = card;
            StatusChecker.DetermineStatusAndTotalPoints(
                hand, nCards, out status,
                out totalPoints);
        }
        public Status GetStatus()
        {
            return status;
        }
        public int GetTotalPoints()
        {
            return totalPoints;
        }
        public bool WantOneMoreCard()
        {
            Console.Write("要再一張牌嗎? (y/n) ");
            string answer = Console.ReadLine();
            return (answer == "Y" || answer == "y");
        }
        public void Dump()
        {
            int i;
            Console.Write("玩家牌: ");
            for (i = 0; i < nCards; ++i)
            {
                hand[i].Dump();
                Console.Write("\t");
                if ((i + 1) % 5 == 0)
                    Console.WriteLine();
            }
            Console.WriteLine();
            Console.WriteLine("玩家總點數: " +
                totalPoints);
        }
    }
}
