//ref design
module CTE ( clk, reset, op_mode, in_en, yuv_in, rgb_in, busy, out_valid, rgb_out, yuv_out);
input   clk ;
input   reset ;
input   op_mode;
input   in_en;
output  busy;
output  out_valid;
input   [7:0]   yuv_in;
output  [23:0]  rgb_out;
input   [23:0]  rgb_in;
output  [7:0]   yuv_out;

// Parameter Definitial_stateion   
parameter Idle  = 3'd0;
parameter YUV2RGB  = 3'b001;
parameter RGB2YUV  = 3'b010;
parameter RGBT = 3'b011;
parameter YUVT = 3'b100;

// Wire/Reg Declartion
reg [23:0]  rgb_out;
reg [7:0]   yuv_out;
reg  busy;
reg  out_valid;
reg [7:0] Y,next_Y;
reg [7:0] U,next_U;
reg [7:0] V,next_V;
reg [7:0] R,next_R;
reg [7:0] G,next_G;
reg [7:0] B,next_B;
reg [7:0]  o_R; 
reg [7:0]  o_G;
reg [7:0]  o_B;
reg [7:0]  o_Y; 
reg [7:0]  o_U;
reg [7:0]  o_V;
reg [13:0] R_temp; 
reg [13:0] G_temp;
reg [13:0] B_temp;
reg [21:0] Y_temp, Y_temp1, Y_temp2, Y_temp3; 
reg [21:0] U_temp, U_temp1, U_temp2, U_temp3;
reg [21:0] V_temp, V_temp1, V_temp2, V_temp3;
reg initial_state, next_initial_state;
reg [1:0] mode,   next_mode;
reg [2:0] state,  next_state;
reg [3:0] count1, next_count1;
reg [3:0] count2, next_count2;


// Combinational Part
//current state
always @ (*) begin 
    case(state)
	Idle:	begin
		out_valid = 0;
		busy = 0;
		end
	YUV2RGB:	begin
		if(initial_state) 		out_valid = 0;
		else if(count1>=1)	out_valid = 0; 
		else			out_valid = 1;

		busy = 0;
		end
	RGBT:	begin
		out_valid = 0;
		busy = 1;
		end
	RGB2YUV:	begin
		if(initial_state)	out_valid = 0;
		else 		out_valid = 1;

		if (mode== 2'b01)				busy = 0;
		else if( (mode ==2'b11) && (count1 == 2'b10) ) 	busy = 0;
		else						busy = 1;
		end
	YUVT:	begin
		out_valid = 0;
		busy = 1;
		end
	default:begin
		out_valid = 0;
		busy = 1;
		end
    endcase
end


// next state
always @ (*) begin
    case ( state )
	Idle: 	begin
		next_initial_state = 1'b1;

		if ( in_en ) begin
		    if ( op_mode ) begin
			next_mode = 2'b01;
			next_state = YUVT;
		    end
		    else begin
			next_mode = 2'b11;
			next_state = YUV2RGB;
		    end
		    next_count1 = 4'd01;
	            next_count2 = 4'd01;
		end
		else begin
		    next_count1 = 4'd00;
                    next_count2 = 4'd00;

		    next_mode = 2'd0;
		    next_state = Idle;
		end
		end
	YUV2RGB:	begin
		next_count1 = count1 + 1'b1;	
		next_count2 = 4'd00;

		next_initial_state = initial_state;
		next_mode = mode;

		if ( next_count1 == next_mode )
		    next_state = RGBT;
		else
		    next_state = YUV2RGB;
		end
	RGBT:	begin
                next_count2 = count2 + 1'b1;
                next_count1 = 4'd00;

		next_initial_state = 1'b0;
		
		if ( count2 == 4'd00 ) begin//****
		    next_state = YUV2RGB;
		    if ( mode == 2'b01 )
                        next_mode = 2'b11;
                    else
                        next_mode = 2'b01;
		end
		else begin
		    next_mode  = mode;
                    next_state = RGBT;
		end
		end
	RGB2YUV:	begin
		next_count1 = count1 + 1'b1;
		next_count2 = 4'd00;

		next_initial_state = initial_state;
		next_mode = mode;

                if ( next_count1 == next_mode )
                    next_state = YUVT;
                else
                    next_state = RGB2YUV;
		end
	YUVT:	begin
                next_count2 = count2 + 1'b1;
                next_count1 = 4'd00;

		next_initial_state = 1'b0;

		if ( count2 > 4'd00 ) begin
		    next_state = RGB2YUV;
		    if ( mode == 2'b01 )
                        next_mode = 2'b11;
                    else
                        next_mode = 2'b01;
		end
		else begin
		    next_mode  = mode;
		    next_state = YUVT;
		end
		end
	default:begin
                next_count1 = 4'd00;
                next_count2 = 4'd00;

		next_initial_state = 1'b1;
		next_mode = 2'd0;

		next_state = Idle;
		end
    endcase
end

// Computation
always @ (*) begin

    R_temp = ( { 3'd0,Y,3'd0} + {{3{V[7]}},V,3'd0} ) + ( {{4{V[7]}},V,2'd0} + {{6{V[7]}},V} );
    G_temp = ( { 3'd0,Y,3'd0} - {{5{U[7]}},U,1'b0}   ) - ( {{4{V[7]}},V,2'd0} + {{5{V[7]}},V,1'b0} );
    B_temp = { 3'd0,Y,3'd0} + {{2{U[7]}},U,4'd00};

    if ( R_temp[13] )         		 o_R = 8'b0;
    else if ( R_temp[12:3] > 10'h0fe)         o_R = 8'hff;
    else if ( !R_temp[2] )         o_R = R_temp[10:3];
    else 	                         o_R = R_temp[10:3] + 1'b1;

    if ( G_temp[13] )        			o_G = 8'b0;
    else if ( G_temp[12:3] > 10'h0fe)        o_G = 8'hff;
    else if ( !G_temp[2] )        o_G = G_temp[10:3];
    else       									  o_G = G_temp[10:3] + 1'b1;

    if ( B_temp[13] )             o_B = 8'b0;
    else if ( B_temp[12:3] > 10'h0fe)        o_B = 8'hff;
    else if ( !B_temp[2] )        o_B = B_temp[10:3];
    else                          o_B = B_temp[10:3] + 1'b1;	

// RGB to YUV 
    Y_temp = ( (R<<9 ) + (R<<6) ) + ( (R<<4) + (R<<2));
    Y_temp1 = ( (G<<10) + (G<<8) ) + ( (G<<3) + (G<<1));
    Y_temp2 = ( (B<<7 ) + (B<<5) ) + (  B + G         );
    Y_temp3 = Y_temp + Y_temp1 + Y_temp2;

    U_temp = ( (R<<8) + (R<<5) ) + ( (R<<3) + (R<<1) );
    U_temp1 = ( (G<<9) + (G<<7) ) + ( (G<<2) + (G)    );
    U_temp2 = ( ((B<<9) + (B<<8)) + ( (B<<7) + (B<<5))) + ( ( (B<<3) + (B<<2) ) + ( (B<<1) + (B) ) );
    U_temp3 = ( U_temp2 - U_temp) - U_temp1;

    V_temp = ( ( (R<<9) + (R<<8) ) + ( (R<<6) + (R<<5) ) ) + ( ( (R<<4) + (R<<3) ) + ( (R<<2) + (R<<1) ) );
    V_temp1 = ( (G<<9) + (G<<8) ) + ( (G<<4) + (G<<3) );
    V_temp2 = ((B<<6) + (B<<5)) + ((B<<1) + (B));
    V_temp3 = (V_temp - V_temp1) - ( (G<<1) + V_temp2 );


    if (Y_temp3[21] == 1'b1)
        o_Y =  8'b0 ;
    else if (Y_temp3[21:11] > 8'd254)
        o_Y = 8'd255;
    else if (Y_temp3[10] == 1'b0)
        o_Y = Y_temp3[18:11];
    else
        o_Y = Y_temp3[18:11] + 1'b1;

    if (U_temp3[21] == 1'b0) begin
        if (U_temp3[20:11] > 10'd116)
            o_U = 8'd117;
        else begin
            if (U_temp3[10] == 1'b0)
                o_U = U_temp3[18:11] ;
            else
                o_U = U_temp3[18:11] + 1'b1;
        end
    end
    else begin
        if (U_temp3[21:11] < 11'b111_1000_1100)
            o_U = 8'b1000_1011;
        else begin
            if (U_temp3[10] == 1'b0)
                o_U = U_temp3[18:11];
            else
                o_U = U_temp3[18:11] + 1'b1;
        end
    end

    if (V_temp3[21] == 1'b0) begin
        if (V_temp3[20:11] > 10'd110)
            o_V = 8'd111;
        else begin
            if (V_temp3[10] == 1'b0)
                o_V = V_temp3[18:11] ;
            else
                o_V = V_temp3[18:11] + 1'b1;
        end
    end
    else begin
        if (V_temp3[21:11] < 11'b111_1000_1100)
            o_V = 8'b1000_1011;
        else begin
            if (V_temp3[10] == 1'b0)
                o_V = V_temp3[18:11];
            else
                o_V = V_temp3[18:11] + 1'b1;
        end
    end
end

// Sequential Part

always @ ( posedge clk or posedge reset ) begin
    if ( reset ) begin 
        state <= 3'd0;
        initial_state  <= 1'b1;
        mode  <= 2'd0;
        count1 <= 4'd00;
        count2 <= 4'd00;
				Y <= 8'h00;
				U <= 8'h00;
				V <= 8'h00;
				R <= 8'h00;
				G <= 8'h00;
				B <= 8'h00;
    end
    else begin
        state <= next_state;
        initial_state  <= next_initial_state;
        mode  <= next_mode;

	count1 <= next_count1;
	count2 <= next_count2;
	Y <= next_Y;
	U <= next_U;
	V <= next_V;
	R <= next_R;
	G <= next_G;
	B <= next_B;
    end
end

// I/O 
always @ (*) begin
    case( state )
	Idle:	begin
		if ( (op_mode == 1'b0) && ( in_en == 1'b1) ) begin
	            next_Y = Y;
                    next_U = yuv_in;
                    next_V = V;

		    next_R = R;
                    next_G = G;
                    next_B = B;

                    yuv_out = o_Y;
		    rgb_out = { o_R, o_G, o_B }; 
		end
		else if ( (op_mode == 1'b1) && ( in_en == 1'b1) ) 
		begin
		    { next_R, next_G, next_B } = rgb_in;

                    next_Y = Y;
                    next_U = U;
                    next_V = V;

                    rgb_out = { o_R, o_G, o_B };
                    yuv_out = o_Y;
		end
		else begin
                    next_Y = Y;
                    next_U = U;
                    next_V = V;

                    rgb_out = { o_R, o_G, o_B };

                    next_R = R;
                    next_G = G;
                    next_B = B;

                    yuv_out = o_Y;
		end
		end
	YUV2RGB: 	begin 
		next_R = R;
		next_G = G;
		next_B = B;

		yuv_out = o_Y;

            	if ( mode == 2'b11 )
                    case ( count1 )
                        2'd0: 	begin
				next_Y = Y; 
				next_U = yuv_in;
				next_V = V;
 				end
                    	2'b01: 	begin
				next_Y = yuv_in;
				next_U = U;
				next_V = V;
 				end
                    	2'b10: 	begin
				next_Y = Y;
				next_U = U;
				next_V = yuv_in;
				end
			default:begin
				next_Y = Y;
                                next_U = U;
                                next_V = V;
				end
                endcase
            	else begin
                    next_Y = yuv_in;
		    next_U = U;
		    next_V = V; 
            	end

		rgb_out = { o_R, o_G, o_B };
	        end
	RGB2YUV:	begin
		next_Y = Y;
                next_U = U;
                next_V = V;

		rgb_out = { o_R, o_G, o_B };

		if ( ~busy ) 
            	    { next_R, next_G, next_B } = rgb_in;
            	else
		    { next_R, next_G, next_B } = { R,G,B };

                if ( mode == 2'b11 )
                    case (count1)
                        2'd0: 	yuv_out = o_U;
                        2'b01: 	yuv_out = o_Y;
                        2'b10:  yuv_out = o_V;
                        default:yuv_out = 0;
                    endcase
                else
		    yuv_out = o_Y;
		end
	default:begin
		next_Y = Y;
                next_U = U;
                next_V = V;

                rgb_out = { o_R, o_G, o_B }; 

		next_R = R;
                next_G = G;
                next_B = B;

                yuv_out = o_Y; 
		end
    endcase


end


endmodule


